/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.socialmessaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.socialmessaging.model.LibraryTemplateBodyInputs;
import software.amazon.awssdk.services.socialmessaging.model.LibraryTemplateButtonInput;
import software.amazon.awssdk.services.socialmessaging.model.MetaLibraryTemplateButtonInputsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetaLibraryTemplate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetaLibraryTemplate> {
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateName").getter(MetaLibraryTemplate.getter(MetaLibraryTemplate::templateName)).setter(MetaLibraryTemplate.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateName").build()}).build();
    private static final SdkField<String> LIBRARY_TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("libraryTemplateName").getter(MetaLibraryTemplate.getter(MetaLibraryTemplate::libraryTemplateName)).setter(MetaLibraryTemplate.setter(Builder::libraryTemplateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("libraryTemplateName").build()}).build();
    private static final SdkField<String> TEMPLATE_CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateCategory").getter(MetaLibraryTemplate.getter(MetaLibraryTemplate::templateCategory)).setter(MetaLibraryTemplate.setter(Builder::templateCategory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateCategory").build()}).build();
    private static final SdkField<String> TEMPLATE_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateLanguage").getter(MetaLibraryTemplate.getter(MetaLibraryTemplate::templateLanguage)).setter(MetaLibraryTemplate.setter(Builder::templateLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateLanguage").build()}).build();
    private static final SdkField<List<LibraryTemplateButtonInput>> LIBRARY_TEMPLATE_BUTTON_INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("libraryTemplateButtonInputs").getter(MetaLibraryTemplate.getter(MetaLibraryTemplate::libraryTemplateButtonInputs)).setter(MetaLibraryTemplate.setter(Builder::libraryTemplateButtonInputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("libraryTemplateButtonInputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LibraryTemplateButtonInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<LibraryTemplateBodyInputs> LIBRARY_TEMPLATE_BODY_INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("libraryTemplateBodyInputs").getter(MetaLibraryTemplate.getter(MetaLibraryTemplate::libraryTemplateBodyInputs)).setter(MetaLibraryTemplate.setter(Builder::libraryTemplateBodyInputs)).constructor(LibraryTemplateBodyInputs::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("libraryTemplateBodyInputs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_NAME_FIELD, LIBRARY_TEMPLATE_NAME_FIELD, TEMPLATE_CATEGORY_FIELD, TEMPLATE_LANGUAGE_FIELD, LIBRARY_TEMPLATE_BUTTON_INPUTS_FIELD, LIBRARY_TEMPLATE_BODY_INPUTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MetaLibraryTemplate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String templateName;
    private final String libraryTemplateName;
    private final String templateCategory;
    private final String templateLanguage;
    private final List<LibraryTemplateButtonInput> libraryTemplateButtonInputs;
    private final LibraryTemplateBodyInputs libraryTemplateBodyInputs;

    private MetaLibraryTemplate(BuilderImpl builder) {
        this.templateName = builder.templateName;
        this.libraryTemplateName = builder.libraryTemplateName;
        this.templateCategory = builder.templateCategory;
        this.templateLanguage = builder.templateLanguage;
        this.libraryTemplateButtonInputs = builder.libraryTemplateButtonInputs;
        this.libraryTemplateBodyInputs = builder.libraryTemplateBodyInputs;
    }

    public final String templateName() {
        return this.templateName;
    }

    public final String libraryTemplateName() {
        return this.libraryTemplateName;
    }

    public final String templateCategory() {
        return this.templateCategory;
    }

    public final String templateLanguage() {
        return this.templateLanguage;
    }

    public final boolean hasLibraryTemplateButtonInputs() {
        return this.libraryTemplateButtonInputs != null && !(this.libraryTemplateButtonInputs instanceof SdkAutoConstructList);
    }

    public final List<LibraryTemplateButtonInput> libraryTemplateButtonInputs() {
        return this.libraryTemplateButtonInputs;
    }

    public final LibraryTemplateBodyInputs libraryTemplateBodyInputs() {
        return this.libraryTemplateBodyInputs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.libraryTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateCategory());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLibraryTemplateButtonInputs() ? this.libraryTemplateButtonInputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.libraryTemplateBodyInputs());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetaLibraryTemplate)) {
            return false;
        }
        MetaLibraryTemplate other = (MetaLibraryTemplate)obj;
        return Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.libraryTemplateName(), other.libraryTemplateName()) && Objects.equals(this.templateCategory(), other.templateCategory()) && Objects.equals(this.templateLanguage(), other.templateLanguage()) && this.hasLibraryTemplateButtonInputs() == other.hasLibraryTemplateButtonInputs() && Objects.equals(this.libraryTemplateButtonInputs(), other.libraryTemplateButtonInputs()) && Objects.equals(this.libraryTemplateBodyInputs(), other.libraryTemplateBodyInputs());
    }

    public final String toString() {
        return ToString.builder((String)"MetaLibraryTemplate").add("TemplateName", (Object)this.templateName()).add("LibraryTemplateName", (Object)this.libraryTemplateName()).add("TemplateCategory", (Object)this.templateCategory()).add("TemplateLanguage", (Object)this.templateLanguage()).add("LibraryTemplateButtonInputs", this.hasLibraryTemplateButtonInputs() ? this.libraryTemplateButtonInputs() : null).add("LibraryTemplateBodyInputs", (Object)this.libraryTemplateBodyInputs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "templateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
            case "libraryTemplateName": {
                return Optional.ofNullable(clazz.cast(this.libraryTemplateName()));
            }
            case "templateCategory": {
                return Optional.ofNullable(clazz.cast(this.templateCategory()));
            }
            case "templateLanguage": {
                return Optional.ofNullable(clazz.cast(this.templateLanguage()));
            }
            case "libraryTemplateButtonInputs": {
                return Optional.ofNullable(clazz.cast(this.libraryTemplateButtonInputs()));
            }
            case "libraryTemplateBodyInputs": {
                return Optional.ofNullable(clazz.cast(this.libraryTemplateBodyInputs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("templateName", TEMPLATE_NAME_FIELD);
        map.put("libraryTemplateName", LIBRARY_TEMPLATE_NAME_FIELD);
        map.put("templateCategory", TEMPLATE_CATEGORY_FIELD);
        map.put("templateLanguage", TEMPLATE_LANGUAGE_FIELD);
        map.put("libraryTemplateButtonInputs", LIBRARY_TEMPLATE_BUTTON_INPUTS_FIELD);
        map.put("libraryTemplateBodyInputs", LIBRARY_TEMPLATE_BODY_INPUTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetaLibraryTemplate, T> g) {
        return obj -> g.apply((MetaLibraryTemplate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String templateName;
        private String libraryTemplateName;
        private String templateCategory;
        private String templateLanguage;
        private List<LibraryTemplateButtonInput> libraryTemplateButtonInputs = DefaultSdkAutoConstructList.getInstance();
        private LibraryTemplateBodyInputs libraryTemplateBodyInputs;

        private BuilderImpl() {
        }

        private BuilderImpl(MetaLibraryTemplate model) {
            this.templateName(model.templateName);
            this.libraryTemplateName(model.libraryTemplateName);
            this.templateCategory(model.templateCategory);
            this.templateLanguage(model.templateLanguage);
            this.libraryTemplateButtonInputs(model.libraryTemplateButtonInputs);
            this.libraryTemplateBodyInputs(model.libraryTemplateBodyInputs);
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getLibraryTemplateName() {
            return this.libraryTemplateName;
        }

        public final void setLibraryTemplateName(String libraryTemplateName) {
            this.libraryTemplateName = libraryTemplateName;
        }

        @Override
        public final Builder libraryTemplateName(String libraryTemplateName) {
            this.libraryTemplateName = libraryTemplateName;
            return this;
        }

        public final String getTemplateCategory() {
            return this.templateCategory;
        }

        public final void setTemplateCategory(String templateCategory) {
            this.templateCategory = templateCategory;
        }

        @Override
        public final Builder templateCategory(String templateCategory) {
            this.templateCategory = templateCategory;
            return this;
        }

        public final String getTemplateLanguage() {
            return this.templateLanguage;
        }

        public final void setTemplateLanguage(String templateLanguage) {
            this.templateLanguage = templateLanguage;
        }

        @Override
        public final Builder templateLanguage(String templateLanguage) {
            this.templateLanguage = templateLanguage;
            return this;
        }

        public final List<LibraryTemplateButtonInput.Builder> getLibraryTemplateButtonInputs() {
            List<LibraryTemplateButtonInput.Builder> result = MetaLibraryTemplateButtonInputsCopier.copyToBuilder(this.libraryTemplateButtonInputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLibraryTemplateButtonInputs(Collection<LibraryTemplateButtonInput.BuilderImpl> libraryTemplateButtonInputs) {
            this.libraryTemplateButtonInputs = MetaLibraryTemplateButtonInputsCopier.copyFromBuilder(libraryTemplateButtonInputs);
        }

        @Override
        public final Builder libraryTemplateButtonInputs(Collection<LibraryTemplateButtonInput> libraryTemplateButtonInputs) {
            this.libraryTemplateButtonInputs = MetaLibraryTemplateButtonInputsCopier.copy(libraryTemplateButtonInputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder libraryTemplateButtonInputs(LibraryTemplateButtonInput ... libraryTemplateButtonInputs) {
            this.libraryTemplateButtonInputs(Arrays.asList(libraryTemplateButtonInputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder libraryTemplateButtonInputs(Consumer<LibraryTemplateButtonInput.Builder> ... libraryTemplateButtonInputs) {
            this.libraryTemplateButtonInputs(Stream.of(libraryTemplateButtonInputs).map(c -> (LibraryTemplateButtonInput)((LibraryTemplateButtonInput.Builder)LibraryTemplateButtonInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final LibraryTemplateBodyInputs.Builder getLibraryTemplateBodyInputs() {
            return this.libraryTemplateBodyInputs != null ? this.libraryTemplateBodyInputs.toBuilder() : null;
        }

        public final void setLibraryTemplateBodyInputs(LibraryTemplateBodyInputs.BuilderImpl libraryTemplateBodyInputs) {
            this.libraryTemplateBodyInputs = libraryTemplateBodyInputs != null ? libraryTemplateBodyInputs.build() : null;
        }

        @Override
        public final Builder libraryTemplateBodyInputs(LibraryTemplateBodyInputs libraryTemplateBodyInputs) {
            this.libraryTemplateBodyInputs = libraryTemplateBodyInputs;
            return this;
        }

        public MetaLibraryTemplate build() {
            return new MetaLibraryTemplate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetaLibraryTemplate> {
        public Builder templateName(String var1);

        public Builder libraryTemplateName(String var1);

        public Builder templateCategory(String var1);

        public Builder templateLanguage(String var1);

        public Builder libraryTemplateButtonInputs(Collection<LibraryTemplateButtonInput> var1);

        public Builder libraryTemplateButtonInputs(LibraryTemplateButtonInput ... var1);

        public Builder libraryTemplateButtonInputs(Consumer<LibraryTemplateButtonInput.Builder> ... var1);

        public Builder libraryTemplateBodyInputs(LibraryTemplateBodyInputs var1);

        default public Builder libraryTemplateBodyInputs(Consumer<LibraryTemplateBodyInputs.Builder> libraryTemplateBodyInputs) {
            return this.libraryTemplateBodyInputs((LibraryTemplateBodyInputs)((LibraryTemplateBodyInputs.Builder)LibraryTemplateBodyInputs.builder().applyMutation(libraryTemplateBodyInputs)).build());
        }
    }
}

