/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.socialmessaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.socialmessaging.model.Tag;
import software.amazon.awssdk.services.socialmessaging.model.TagListCopier;
import software.amazon.awssdk.services.socialmessaging.model.WhatsAppBusinessAccountEventDestination;
import software.amazon.awssdk.services.socialmessaging.model.WhatsAppBusinessAccountEventDestinationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WabaSetupFinalization
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WabaSetupFinalization> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(WabaSetupFinalization.getter(WabaSetupFinalization::id)).setter(WabaSetupFinalization.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<List<WhatsAppBusinessAccountEventDestination>> EVENT_DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("eventDestinations").getter(WabaSetupFinalization.getter(WabaSetupFinalization::eventDestinations)).setter(WabaSetupFinalization.setter(Builder::eventDestinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventDestinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WhatsAppBusinessAccountEventDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(WabaSetupFinalization.getter(WabaSetupFinalization::tags)).setter(WabaSetupFinalization.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, EVENT_DESTINATIONS_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final List<WhatsAppBusinessAccountEventDestination> eventDestinations;
    private final List<Tag> tags;

    private WabaSetupFinalization(BuilderImpl builder) {
        this.id = builder.id;
        this.eventDestinations = builder.eventDestinations;
        this.tags = builder.tags;
    }

    public final String id() {
        return this.id;
    }

    public final boolean hasEventDestinations() {
        return this.eventDestinations != null && !(this.eventDestinations instanceof SdkAutoConstructList);
    }

    public final List<WhatsAppBusinessAccountEventDestination> eventDestinations() {
        return this.eventDestinations;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventDestinations() ? this.eventDestinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WabaSetupFinalization)) {
            return false;
        }
        WabaSetupFinalization other = (WabaSetupFinalization)obj;
        return Objects.equals(this.id(), other.id()) && this.hasEventDestinations() == other.hasEventDestinations() && Objects.equals(this.eventDestinations(), other.eventDestinations()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"WabaSetupFinalization").add("Id", (Object)this.id()).add("EventDestinations", this.hasEventDestinations() ? this.eventDestinations() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "eventDestinations": {
                return Optional.ofNullable(clazz.cast(this.eventDestinations()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WabaSetupFinalization, T> g) {
        return obj -> g.apply((WabaSetupFinalization)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private List<WhatsAppBusinessAccountEventDestination> eventDestinations = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WabaSetupFinalization model) {
            this.id(model.id);
            this.eventDestinations(model.eventDestinations);
            this.tags(model.tags);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final List<WhatsAppBusinessAccountEventDestination.Builder> getEventDestinations() {
            List<WhatsAppBusinessAccountEventDestination.Builder> result = WhatsAppBusinessAccountEventDestinationsCopier.copyToBuilder(this.eventDestinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventDestinations(Collection<WhatsAppBusinessAccountEventDestination.BuilderImpl> eventDestinations) {
            this.eventDestinations = WhatsAppBusinessAccountEventDestinationsCopier.copyFromBuilder(eventDestinations);
        }

        @Override
        public final Builder eventDestinations(Collection<WhatsAppBusinessAccountEventDestination> eventDestinations) {
            this.eventDestinations = WhatsAppBusinessAccountEventDestinationsCopier.copy(eventDestinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventDestinations(WhatsAppBusinessAccountEventDestination ... eventDestinations) {
            this.eventDestinations(Arrays.asList(eventDestinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventDestinations(Consumer<WhatsAppBusinessAccountEventDestination.Builder> ... eventDestinations) {
            this.eventDestinations(Stream.of(eventDestinations).map(c -> (WhatsAppBusinessAccountEventDestination)((WhatsAppBusinessAccountEventDestination.Builder)WhatsAppBusinessAccountEventDestination.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public WabaSetupFinalization build() {
            return new WabaSetupFinalization(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WabaSetupFinalization> {
        public Builder id(String var1);

        public Builder eventDestinations(Collection<WhatsAppBusinessAccountEventDestination> var1);

        public Builder eventDestinations(WhatsAppBusinessAccountEventDestination ... var1);

        public Builder eventDestinations(Consumer<WhatsAppBusinessAccountEventDestination.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

