/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.socialmessaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.socialmessaging.model.S3File;
import software.amazon.awssdk.services.socialmessaging.model.S3PresignedUrl;
import software.amazon.awssdk.services.socialmessaging.model.SocialMessagingRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PostWhatsAppMessageMediaRequest
extends SocialMessagingRequest
implements ToCopyableBuilder<Builder, PostWhatsAppMessageMediaRequest> {
    private static final SdkField<String> ORIGINATION_PHONE_NUMBER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("originationPhoneNumberId").getter(PostWhatsAppMessageMediaRequest.getter(PostWhatsAppMessageMediaRequest::originationPhoneNumberId)).setter(PostWhatsAppMessageMediaRequest.setter(Builder::originationPhoneNumberId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originationPhoneNumberId").build()}).build();
    private static final SdkField<S3PresignedUrl> SOURCE_S3_PRESIGNED_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sourceS3PresignedUrl").getter(PostWhatsAppMessageMediaRequest.getter(PostWhatsAppMessageMediaRequest::sourceS3PresignedUrl)).setter(PostWhatsAppMessageMediaRequest.setter(Builder::sourceS3PresignedUrl)).constructor(S3PresignedUrl::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceS3PresignedUrl").build()}).build();
    private static final SdkField<S3File> SOURCE_S3_FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sourceS3File").getter(PostWhatsAppMessageMediaRequest.getter(PostWhatsAppMessageMediaRequest::sourceS3File)).setter(PostWhatsAppMessageMediaRequest.setter(Builder::sourceS3File)).constructor(S3File::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceS3File").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORIGINATION_PHONE_NUMBER_ID_FIELD, SOURCE_S3_PRESIGNED_URL_FIELD, SOURCE_S3_FILE_FIELD));
    private final String originationPhoneNumberId;
    private final S3PresignedUrl sourceS3PresignedUrl;
    private final S3File sourceS3File;

    private PostWhatsAppMessageMediaRequest(BuilderImpl builder) {
        super(builder);
        this.originationPhoneNumberId = builder.originationPhoneNumberId;
        this.sourceS3PresignedUrl = builder.sourceS3PresignedUrl;
        this.sourceS3File = builder.sourceS3File;
    }

    public final String originationPhoneNumberId() {
        return this.originationPhoneNumberId;
    }

    public final S3PresignedUrl sourceS3PresignedUrl() {
        return this.sourceS3PresignedUrl;
    }

    public final S3File sourceS3File() {
        return this.sourceS3File;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.originationPhoneNumberId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceS3PresignedUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceS3File());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PostWhatsAppMessageMediaRequest)) {
            return false;
        }
        PostWhatsAppMessageMediaRequest other = (PostWhatsAppMessageMediaRequest)((Object)obj);
        return Objects.equals(this.originationPhoneNumberId(), other.originationPhoneNumberId()) && Objects.equals(this.sourceS3PresignedUrl(), other.sourceS3PresignedUrl()) && Objects.equals(this.sourceS3File(), other.sourceS3File());
    }

    public final String toString() {
        return ToString.builder((String)"PostWhatsAppMessageMediaRequest").add("OriginationPhoneNumberId", (Object)this.originationPhoneNumberId()).add("SourceS3PresignedUrl", (Object)(this.sourceS3PresignedUrl() == null ? null : "*** Sensitive Data Redacted ***")).add("SourceS3File", (Object)(this.sourceS3File() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "originationPhoneNumberId": {
                return Optional.ofNullable(clazz.cast(this.originationPhoneNumberId()));
            }
            case "sourceS3PresignedUrl": {
                return Optional.ofNullable(clazz.cast(this.sourceS3PresignedUrl()));
            }
            case "sourceS3File": {
                return Optional.ofNullable(clazz.cast(this.sourceS3File()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PostWhatsAppMessageMediaRequest, T> g) {
        return obj -> g.apply((PostWhatsAppMessageMediaRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SocialMessagingRequest.BuilderImpl
    implements Builder {
        private String originationPhoneNumberId;
        private S3PresignedUrl sourceS3PresignedUrl;
        private S3File sourceS3File;

        private BuilderImpl() {
        }

        private BuilderImpl(PostWhatsAppMessageMediaRequest model) {
            super(model);
            this.originationPhoneNumberId(model.originationPhoneNumberId);
            this.sourceS3PresignedUrl(model.sourceS3PresignedUrl);
            this.sourceS3File(model.sourceS3File);
        }

        public final String getOriginationPhoneNumberId() {
            return this.originationPhoneNumberId;
        }

        public final void setOriginationPhoneNumberId(String originationPhoneNumberId) {
            this.originationPhoneNumberId = originationPhoneNumberId;
        }

        @Override
        public final Builder originationPhoneNumberId(String originationPhoneNumberId) {
            this.originationPhoneNumberId = originationPhoneNumberId;
            return this;
        }

        public final S3PresignedUrl.Builder getSourceS3PresignedUrl() {
            return this.sourceS3PresignedUrl != null ? this.sourceS3PresignedUrl.toBuilder() : null;
        }

        public final void setSourceS3PresignedUrl(S3PresignedUrl.BuilderImpl sourceS3PresignedUrl) {
            this.sourceS3PresignedUrl = sourceS3PresignedUrl != null ? sourceS3PresignedUrl.build() : null;
        }

        @Override
        public final Builder sourceS3PresignedUrl(S3PresignedUrl sourceS3PresignedUrl) {
            this.sourceS3PresignedUrl = sourceS3PresignedUrl;
            return this;
        }

        public final S3File.Builder getSourceS3File() {
            return this.sourceS3File != null ? this.sourceS3File.toBuilder() : null;
        }

        public final void setSourceS3File(S3File.BuilderImpl sourceS3File) {
            this.sourceS3File = sourceS3File != null ? sourceS3File.build() : null;
        }

        @Override
        public final Builder sourceS3File(S3File sourceS3File) {
            this.sourceS3File = sourceS3File;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PostWhatsAppMessageMediaRequest build() {
            return new PostWhatsAppMessageMediaRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SocialMessagingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PostWhatsAppMessageMediaRequest> {
        public Builder originationPhoneNumberId(String var1);

        public Builder sourceS3PresignedUrl(S3PresignedUrl var1);

        default public Builder sourceS3PresignedUrl(Consumer<S3PresignedUrl.Builder> sourceS3PresignedUrl) {
            return this.sourceS3PresignedUrl((S3PresignedUrl)((S3PresignedUrl.Builder)S3PresignedUrl.builder().applyMutation(sourceS3PresignedUrl)).build());
        }

        public Builder sourceS3File(S3File var1);

        default public Builder sourceS3File(Consumer<S3File.Builder> sourceS3File) {
            return this.sourceS3File((S3File)((S3File.Builder)S3File.builder().applyMutation(sourceS3File)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

