/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sns.model.ActionsListCopier;
import software.amazon.awssdk.services.sns.model.DelegatesListCopier;
import software.amazon.awssdk.services.sns.model.SnsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddPermissionRequest
extends SnsRequest
implements ToCopyableBuilder<Builder, AddPermissionRequest> {
    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TopicArn").getter(AddPermissionRequest.getter(AddPermissionRequest::topicArn)).setter(AddPermissionRequest.setter(Builder::topicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicArn").build()}).build();
    private static final SdkField<String> LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Label").getter(AddPermissionRequest.getter(AddPermissionRequest::label)).setter(AddPermissionRequest.setter(Builder::label)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()}).build();
    private static final SdkField<List<String>> AWS_ACCOUNT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AWSAccountIds").getter(AddPermissionRequest.getter(AddPermissionRequest::awsAccountIds)).setter(AddPermissionRequest.setter(Builder::awsAccountIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AWSAccountId").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ACTION_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ActionNames").getter(AddPermissionRequest.getter(AddPermissionRequest::actionNames)).setter(AddPermissionRequest.setter(Builder::actionNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionName").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_ARN_FIELD, LABEL_FIELD, AWS_ACCOUNT_IDS_FIELD, ACTION_NAMES_FIELD));
    private final String topicArn;
    private final String label;
    private final List<String> awsAccountIds;
    private final List<String> actionNames;

    private AddPermissionRequest(BuilderImpl builder) {
        super(builder);
        this.topicArn = builder.topicArn;
        this.label = builder.label;
        this.awsAccountIds = builder.awsAccountIds;
        this.actionNames = builder.actionNames;
    }

    public final String topicArn() {
        return this.topicArn;
    }

    public final String label() {
        return this.label;
    }

    public final boolean hasAwsAccountIds() {
        return this.awsAccountIds != null && !(this.awsAccountIds instanceof SdkAutoConstructList);
    }

    public final List<String> awsAccountIds() {
        return this.awsAccountIds;
    }

    public final boolean hasActionNames() {
        return this.actionNames != null && !(this.actionNames instanceof SdkAutoConstructList);
    }

    public final List<String> actionNames() {
        return this.actionNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.label());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAwsAccountIds() ? this.awsAccountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActionNames() ? this.actionNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddPermissionRequest)) {
            return false;
        }
        AddPermissionRequest other = (AddPermissionRequest)((Object)obj);
        return Objects.equals(this.topicArn(), other.topicArn()) && Objects.equals(this.label(), other.label()) && this.hasAwsAccountIds() == other.hasAwsAccountIds() && Objects.equals(this.awsAccountIds(), other.awsAccountIds()) && this.hasActionNames() == other.hasActionNames() && Objects.equals(this.actionNames(), other.actionNames());
    }

    public final String toString() {
        return ToString.builder((String)"AddPermissionRequest").add("TopicArn", (Object)this.topicArn()).add("Label", (Object)this.label()).add("AWSAccountIds", this.hasAwsAccountIds() ? this.awsAccountIds() : null).add("ActionNames", this.hasActionNames() ? this.actionNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TopicArn": {
                return Optional.ofNullable(clazz.cast(this.topicArn()));
            }
            case "Label": {
                return Optional.ofNullable(clazz.cast(this.label()));
            }
            case "AWSAccountIds": {
                return Optional.ofNullable(clazz.cast(this.awsAccountIds()));
            }
            case "ActionNames": {
                return Optional.ofNullable(clazz.cast(this.actionNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddPermissionRequest, T> g) {
        return obj -> g.apply((AddPermissionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SnsRequest.BuilderImpl
    implements Builder {
        private String topicArn;
        private String label;
        private List<String> awsAccountIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> actionNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddPermissionRequest model) {
            super(model);
            this.topicArn(model.topicArn);
            this.label(model.label);
            this.awsAccountIds(model.awsAccountIds);
            this.actionNames(model.actionNames);
        }

        public final String getTopicArn() {
            return this.topicArn;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final String getLabel() {
            return this.label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final Collection<String> getAwsAccountIds() {
            if (this.awsAccountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.awsAccountIds;
        }

        public final void setAwsAccountIds(Collection<String> awsAccountIds) {
            this.awsAccountIds = DelegatesListCopier.copy(awsAccountIds);
        }

        @Override
        public final Builder awsAccountIds(Collection<String> awsAccountIds) {
            this.awsAccountIds = DelegatesListCopier.copy(awsAccountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsAccountIds(String ... awsAccountIds) {
            this.awsAccountIds(Arrays.asList(awsAccountIds));
            return this;
        }

        public final Collection<String> getActionNames() {
            if (this.actionNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.actionNames;
        }

        public final void setActionNames(Collection<String> actionNames) {
            this.actionNames = ActionsListCopier.copy(actionNames);
        }

        @Override
        public final Builder actionNames(Collection<String> actionNames) {
            this.actionNames = ActionsListCopier.copy(actionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionNames(String ... actionNames) {
            this.actionNames(Arrays.asList(actionNames));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddPermissionRequest build() {
            return new AddPermissionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SnsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddPermissionRequest> {
        public Builder topicArn(String var1);

        public Builder label(String var1);

        public Builder awsAccountIds(Collection<String> var1);

        public Builder awsAccountIds(String ... var1);

        public Builder actionNames(Collection<String> var1);

        public Builder actionNames(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

