/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sns.DefaultSnsAsyncClient;
import software.amazon.awssdk.services.sns.DefaultSnsBaseClientBuilder;
import software.amazon.awssdk.services.sns.SnsAsyncClient;
import software.amazon.awssdk.services.sns.SnsAsyncClientBuilder;
import software.amazon.awssdk.services.sns.SnsServiceClientConfiguration;
import software.amazon.awssdk.services.sns.endpoints.SnsEndpointProvider;

@SdkInternalApi
final class DefaultSnsAsyncClientBuilder
extends DefaultSnsBaseClientBuilder<SnsAsyncClientBuilder, SnsAsyncClient>
implements SnsAsyncClientBuilder {
    DefaultSnsAsyncClientBuilder() {
    }

    @Override
    public DefaultSnsAsyncClientBuilder endpointProvider(SnsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SnsAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultSnsAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        SnsServiceClientConfiguration serviceClientConfiguration = SnsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultSnsAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

