/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum NumberCapability {
    SMS("SMS"),
    MMS("MMS"),
    VOICE("VOICE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private NumberCapability(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NumberCapability fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(NumberCapability.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NumberCapability> knownValues() {
        return Stream.of(NumberCapability.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

