/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.services.sns.SnsClient;
import software.amazon.awssdk.services.sns.model.AddPermissionRequest;
import software.amazon.awssdk.services.sns.model.AddPermissionResponse;
import software.amazon.awssdk.services.sns.model.AuthorizationErrorException;
import software.amazon.awssdk.services.sns.model.BatchEntryIdsNotDistinctException;
import software.amazon.awssdk.services.sns.model.BatchRequestTooLongException;
import software.amazon.awssdk.services.sns.model.CheckIfPhoneNumberIsOptedOutRequest;
import software.amazon.awssdk.services.sns.model.CheckIfPhoneNumberIsOptedOutResponse;
import software.amazon.awssdk.services.sns.model.ConcurrentAccessException;
import software.amazon.awssdk.services.sns.model.ConfirmSubscriptionRequest;
import software.amazon.awssdk.services.sns.model.ConfirmSubscriptionResponse;
import software.amazon.awssdk.services.sns.model.CreatePlatformApplicationRequest;
import software.amazon.awssdk.services.sns.model.CreatePlatformApplicationResponse;
import software.amazon.awssdk.services.sns.model.CreatePlatformEndpointRequest;
import software.amazon.awssdk.services.sns.model.CreatePlatformEndpointResponse;
import software.amazon.awssdk.services.sns.model.CreateSmsSandboxPhoneNumberRequest;
import software.amazon.awssdk.services.sns.model.CreateSmsSandboxPhoneNumberResponse;
import software.amazon.awssdk.services.sns.model.CreateTopicRequest;
import software.amazon.awssdk.services.sns.model.CreateTopicResponse;
import software.amazon.awssdk.services.sns.model.DeleteEndpointRequest;
import software.amazon.awssdk.services.sns.model.DeleteEndpointResponse;
import software.amazon.awssdk.services.sns.model.DeletePlatformApplicationRequest;
import software.amazon.awssdk.services.sns.model.DeletePlatformApplicationResponse;
import software.amazon.awssdk.services.sns.model.DeleteSmsSandboxPhoneNumberRequest;
import software.amazon.awssdk.services.sns.model.DeleteSmsSandboxPhoneNumberResponse;
import software.amazon.awssdk.services.sns.model.DeleteTopicRequest;
import software.amazon.awssdk.services.sns.model.DeleteTopicResponse;
import software.amazon.awssdk.services.sns.model.EmptyBatchRequestException;
import software.amazon.awssdk.services.sns.model.EndpointDisabledException;
import software.amazon.awssdk.services.sns.model.FilterPolicyLimitExceededException;
import software.amazon.awssdk.services.sns.model.GetEndpointAttributesRequest;
import software.amazon.awssdk.services.sns.model.GetEndpointAttributesResponse;
import software.amazon.awssdk.services.sns.model.GetPlatformApplicationAttributesRequest;
import software.amazon.awssdk.services.sns.model.GetPlatformApplicationAttributesResponse;
import software.amazon.awssdk.services.sns.model.GetSmsAttributesRequest;
import software.amazon.awssdk.services.sns.model.GetSmsAttributesResponse;
import software.amazon.awssdk.services.sns.model.GetSmsSandboxAccountStatusRequest;
import software.amazon.awssdk.services.sns.model.GetSmsSandboxAccountStatusResponse;
import software.amazon.awssdk.services.sns.model.GetSubscriptionAttributesRequest;
import software.amazon.awssdk.services.sns.model.GetSubscriptionAttributesResponse;
import software.amazon.awssdk.services.sns.model.GetTopicAttributesRequest;
import software.amazon.awssdk.services.sns.model.GetTopicAttributesResponse;
import software.amazon.awssdk.services.sns.model.InternalErrorException;
import software.amazon.awssdk.services.sns.model.InvalidBatchEntryIdException;
import software.amazon.awssdk.services.sns.model.InvalidParameterException;
import software.amazon.awssdk.services.sns.model.InvalidParameterValueException;
import software.amazon.awssdk.services.sns.model.InvalidSecurityException;
import software.amazon.awssdk.services.sns.model.KmsAccessDeniedException;
import software.amazon.awssdk.services.sns.model.KmsDisabledException;
import software.amazon.awssdk.services.sns.model.KmsInvalidStateException;
import software.amazon.awssdk.services.sns.model.KmsNotFoundException;
import software.amazon.awssdk.services.sns.model.KmsOptInRequiredException;
import software.amazon.awssdk.services.sns.model.KmsThrottlingException;
import software.amazon.awssdk.services.sns.model.ListEndpointsByPlatformApplicationRequest;
import software.amazon.awssdk.services.sns.model.ListEndpointsByPlatformApplicationResponse;
import software.amazon.awssdk.services.sns.model.ListOriginationNumbersRequest;
import software.amazon.awssdk.services.sns.model.ListOriginationNumbersResponse;
import software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutRequest;
import software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutResponse;
import software.amazon.awssdk.services.sns.model.ListPlatformApplicationsRequest;
import software.amazon.awssdk.services.sns.model.ListPlatformApplicationsResponse;
import software.amazon.awssdk.services.sns.model.ListSmsSandboxPhoneNumbersRequest;
import software.amazon.awssdk.services.sns.model.ListSmsSandboxPhoneNumbersResponse;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicRequest;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicResponse;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsRequest;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsResponse;
import software.amazon.awssdk.services.sns.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.sns.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.sns.model.ListTopicsRequest;
import software.amazon.awssdk.services.sns.model.ListTopicsResponse;
import software.amazon.awssdk.services.sns.model.NotFoundException;
import software.amazon.awssdk.services.sns.model.OptInPhoneNumberRequest;
import software.amazon.awssdk.services.sns.model.OptInPhoneNumberResponse;
import software.amazon.awssdk.services.sns.model.OptedOutException;
import software.amazon.awssdk.services.sns.model.PlatformApplicationDisabledException;
import software.amazon.awssdk.services.sns.model.PublishBatchRequest;
import software.amazon.awssdk.services.sns.model.PublishBatchResponse;
import software.amazon.awssdk.services.sns.model.PublishRequest;
import software.amazon.awssdk.services.sns.model.PublishResponse;
import software.amazon.awssdk.services.sns.model.RemovePermissionRequest;
import software.amazon.awssdk.services.sns.model.RemovePermissionResponse;
import software.amazon.awssdk.services.sns.model.ResourceNotFoundException;
import software.amazon.awssdk.services.sns.model.SetEndpointAttributesRequest;
import software.amazon.awssdk.services.sns.model.SetEndpointAttributesResponse;
import software.amazon.awssdk.services.sns.model.SetPlatformApplicationAttributesRequest;
import software.amazon.awssdk.services.sns.model.SetPlatformApplicationAttributesResponse;
import software.amazon.awssdk.services.sns.model.SetSmsAttributesRequest;
import software.amazon.awssdk.services.sns.model.SetSmsAttributesResponse;
import software.amazon.awssdk.services.sns.model.SetSubscriptionAttributesRequest;
import software.amazon.awssdk.services.sns.model.SetSubscriptionAttributesResponse;
import software.amazon.awssdk.services.sns.model.SetTopicAttributesRequest;
import software.amazon.awssdk.services.sns.model.SetTopicAttributesResponse;
import software.amazon.awssdk.services.sns.model.SnsException;
import software.amazon.awssdk.services.sns.model.SnsRequest;
import software.amazon.awssdk.services.sns.model.StaleTagException;
import software.amazon.awssdk.services.sns.model.SubscribeRequest;
import software.amazon.awssdk.services.sns.model.SubscribeResponse;
import software.amazon.awssdk.services.sns.model.SubscriptionLimitExceededException;
import software.amazon.awssdk.services.sns.model.TagLimitExceededException;
import software.amazon.awssdk.services.sns.model.TagPolicyException;
import software.amazon.awssdk.services.sns.model.TagResourceRequest;
import software.amazon.awssdk.services.sns.model.TagResourceResponse;
import software.amazon.awssdk.services.sns.model.ThrottledException;
import software.amazon.awssdk.services.sns.model.TooManyEntriesInBatchRequestException;
import software.amazon.awssdk.services.sns.model.TopicLimitExceededException;
import software.amazon.awssdk.services.sns.model.UnsubscribeRequest;
import software.amazon.awssdk.services.sns.model.UnsubscribeResponse;
import software.amazon.awssdk.services.sns.model.UntagResourceRequest;
import software.amazon.awssdk.services.sns.model.UntagResourceResponse;
import software.amazon.awssdk.services.sns.model.UserErrorException;
import software.amazon.awssdk.services.sns.model.ValidationException;
import software.amazon.awssdk.services.sns.model.VerificationException;
import software.amazon.awssdk.services.sns.model.VerifySmsSandboxPhoneNumberRequest;
import software.amazon.awssdk.services.sns.model.VerifySmsSandboxPhoneNumberResponse;
import software.amazon.awssdk.services.sns.paginators.ListEndpointsByPlatformApplicationIterable;
import software.amazon.awssdk.services.sns.paginators.ListOriginationNumbersIterable;
import software.amazon.awssdk.services.sns.paginators.ListPhoneNumbersOptedOutIterable;
import software.amazon.awssdk.services.sns.paginators.ListPlatformApplicationsIterable;
import software.amazon.awssdk.services.sns.paginators.ListSMSSandboxPhoneNumbersIterable;
import software.amazon.awssdk.services.sns.paginators.ListSubscriptionsByTopicIterable;
import software.amazon.awssdk.services.sns.paginators.ListSubscriptionsIterable;
import software.amazon.awssdk.services.sns.paginators.ListTopicsIterable;
import software.amazon.awssdk.services.sns.transform.AddPermissionRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.CheckIfPhoneNumberIsOptedOutRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.ConfirmSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.CreatePlatformApplicationRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.CreatePlatformEndpointRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.CreateSmsSandboxPhoneNumberRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.CreateTopicRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.DeleteEndpointRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.DeletePlatformApplicationRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.DeleteSmsSandboxPhoneNumberRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.DeleteTopicRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.GetEndpointAttributesRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.GetPlatformApplicationAttributesRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.GetSmsAttributesRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.GetSmsSandboxAccountStatusRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.GetSubscriptionAttributesRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.GetTopicAttributesRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.ListEndpointsByPlatformApplicationRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.ListOriginationNumbersRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.ListPhoneNumbersOptedOutRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.ListPlatformApplicationsRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.ListSmsSandboxPhoneNumbersRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.ListSubscriptionsByTopicRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.ListSubscriptionsRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.ListTopicsRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.OptInPhoneNumberRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.PublishBatchRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.PublishRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.RemovePermissionRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.SetEndpointAttributesRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.SetPlatformApplicationAttributesRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.SetSmsAttributesRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.SetSubscriptionAttributesRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.SetTopicAttributesRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.SubscribeRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.UnsubscribeRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.VerifySmsSandboxPhoneNumberRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultSnsClient
implements SnsClient {
    private static final Logger log = Logger.loggerFor(DefaultSnsClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsQueryProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultSnsClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "sns";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddPermissionResponse addPermission(AddPermissionRequest addPermissionRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, NotFoundException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AddPermissionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSnsClient.resolveMetricPublishers(this.clientConfiguration, addPermissionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SNS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddPermission");
            AddPermissionResponse addPermissionResponse = (AddPermissionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddPermission").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addPermissionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AddPermissionRequestMarshaller(this.protocolFactory)));
            return addPermissionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnsClient.lambda$addPermission$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CheckIfPhoneNumberIsOptedOutResponse checkIfPhoneNumberIsOptedOut(CheckIfPhoneNumberIsOptedOutRequest checkIfPhoneNumberIsOptedOutRequest) throws ThrottledException, InternalErrorException, AuthorizationErrorException, InvalidParameterException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CheckIfPhoneNumberIsOptedOutResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSnsClient.resolveMetricPublishers(this.clientConfiguration, checkIfPhoneNumberIsOptedOutRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SNS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CheckIfPhoneNumberIsOptedOut");
            CheckIfPhoneNumberIsOptedOutResponse checkIfPhoneNumberIsOptedOutResponse = (CheckIfPhoneNumberIsOptedOutResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CheckIfPhoneNumberIsOptedOut").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)checkIfPhoneNumberIsOptedOutRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CheckIfPhoneNumberIsOptedOutRequestMarshaller(this.protocolFactory)));
            return checkIfPhoneNumberIsOptedOutResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnsClient.lambda$checkIfPhoneNumberIsOptedOut$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfirmSubscriptionResponse confirmSubscription(ConfirmSubscriptionRequest confirmSubscriptionRequest) throws SubscriptionLimitExceededException, InvalidParameterException, NotFoundException, InternalErrorException, AuthorizationErrorException, FilterPolicyLimitExceededException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ConfirmSubscriptionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSnsClient.resolveMetricPublishers(this.clientConfiguration, confirmSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SNS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ConfirmSubscription");
            ConfirmSubscriptionResponse confirmSubscriptionResponse = (ConfirmSubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ConfirmSubscription").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)confirmSubscriptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ConfirmSubscriptionRequestMarshaller(this.protocolFactory)));
            return confirmSubscriptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnsClient.lambda$confirmSubscription$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePlatformApplicationResponse createPlatformApplication(CreatePlatformApplicationRequest createPlatformApplicationRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreatePlatformApplicationResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSnsClient.resolveMetricPublishers(this.clientConfiguration, createPlatformApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SNS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePlatformApplication");
            CreatePlatformApplicationResponse createPlatformApplicationResponse = (CreatePlatformApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePlatformApplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPlatformApplicationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreatePlatformApplicationRequestMarshaller(this.protocolFactory)));
            return createPlatformApplicationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnsClient.lambda$createPlatformApplication$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePlatformEndpointResponse createPlatformEndpoint(CreatePlatformEndpointRequest createPlatformEndpointRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, NotFoundException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreatePlatformEndpointResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSnsClient.resolveMetricPublishers(this.clientConfiguration, createPlatformEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SNS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePlatformEndpoint");
            CreatePlatformEndpointResponse createPlatformEndpointResponse = (CreatePlatformEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePlatformEndpoint").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPlatformEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreatePlatformEndpointRequestMarshaller(this.protocolFactory)));
            return createPlatformEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnsClient.lambda$createPlatformEndpoint$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSmsSandboxPhoneNumberResponse createSMSSandboxPhoneNumber(CreateSmsSandboxPhoneNumberRequest createSmsSandboxPhoneNumberRequest) throws AuthorizationErrorException, InternalErrorException, InvalidParameterException, OptedOutException, UserErrorException, ThrottledException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateSmsSandboxPhoneNumberResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSnsClient.resolveMetricPublishers(this.clientConfiguration, createSmsSandboxPhoneNumberRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SNS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSMSSandboxPhoneNumber");
            CreateSmsSandboxPhoneNumberResponse createSmsSandboxPhoneNumberResponse = (CreateSmsSandboxPhoneNumberResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSMSSandboxPhoneNumber").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSmsSandboxPhoneNumberRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSmsSandboxPhoneNumberRequestMarshaller(this.protocolFactory)));
            return createSmsSandboxPhoneNumberResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnsClient.lambda$createSMSSandboxPhoneNumber$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTopicResponse createTopic(CreateTopicRequest createTopicRequest) throws InvalidParameterException, TopicLimitExceededException, InternalErrorException, AuthorizationErrorException, InvalidSecurityException, TagLimitExceededException, StaleTagException, TagPolicyException, ConcurrentAccessException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateTopicResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSnsClient.resolveMetricPublishers(this.clientConfiguration, createTopicRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SNS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTopic");
            CreateTopicResponse createTopicResponse = (CreateTopicResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTopic").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createTopicRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateTopicRequestMarshaller(this.protocolFactory)));
            return createTopicResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnsClient.lambda$createTopic$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteEndpointResponse deleteEndpoint(DeleteEndpointRequest deleteEndpointRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteEndpointResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSnsClient.resolveMetricPublishers(this.clientConfiguration, deleteEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SNS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEndpoint");
            DeleteEndpointResponse deleteEndpointResponse = (DeleteEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEndpoint").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteEndpointRequestMarshaller(this.protocolFactory)));
            return deleteEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnsClient.lambda$deleteEndpoint$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePlatformApplicationResponse deletePlatformApplication(DeletePlatformApplicationRequest deletePlatformApplicationRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeletePlatformApplicationResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSnsClient.resolveMetricPublishers(this.clientConfiguration, deletePlatformApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SNS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePlatformApplication");
            DeletePlatformApplicationResponse deletePlatformApplicationResponse = (DeletePlatformApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePlatformApplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deletePlatformApplicationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeletePlatformApplicationRequestMarshaller(this.protocolFactory)));
            return deletePlatformApplicationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnsClient.lambda$deletePlatformApplication$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSmsSandboxPhoneNumberResponse deleteSMSSandboxPhoneNumber(DeleteSmsSandboxPhoneNumberRequest deleteSmsSandboxPhoneNumberRequest) throws AuthorizationErrorException, InternalErrorException, InvalidParameterException, ResourceNotFoundException, UserErrorException, ThrottledException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteSmsSandboxPhoneNumberResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSnsClient.resolveMetricPublishers(this.clientConfiguration, deleteSmsSandboxPhoneNumberRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SNS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSMSSandboxPhoneNumber");
            DeleteSmsSandboxPhoneNumberResponse deleteSmsSandboxPhoneNumberResponse = (DeleteSmsSandboxPhoneNumberResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSMSSandboxPhoneNumber").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSmsSandboxPhoneNumberRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSmsSandboxPhoneNumberRequestMarshaller(this.protocolFactory)));
            return deleteSmsSandboxPhoneNumberResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnsClient.lambda$deleteSMSSandboxPhoneNumber$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTopicResponse deleteTopic(DeleteTopicRequest deleteTopicRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, NotFoundException, StaleTagException, TagPolicyException, ConcurrentAccessException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteTopicResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSnsClient.resolveMetricPublishers(this.clientConfiguration, deleteTopicRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SNS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTopic");
            DeleteTopicResponse deleteTopicResponse = (DeleteTopicResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTopic").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteTopicRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTopicRequestMarshaller(this.protocolFactory)));
            return deleteTopicResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnsClient.lambda$deleteTopic$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetEndpointAttributesResponse getEndpointAttributes(GetEndpointAttributesRequest getEndpointAttributesRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, NotFoundException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetEndpointAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSnsClient.resolveMetricPublishers(this.clientConfiguration, getEndpointAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SNS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEndpointAttributes");
            GetEndpointAttributesResponse getEndpointAttributesResponse = (GetEndpointAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEndpointAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getEndpointAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetEndpointAttributesRequestMarshaller(this.protocolFactory)));
            return getEndpointAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnsClient.lambda$getEndpointAttributes$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPlatformApplicationAttributesResponse getPlatformApplicationAttributes(GetPlatformApplicationAttributesRequest getPlatformApplicationAttributesRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, NotFoundException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetPlatformApplicationAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSnsClient.resolveMetricPublishers(this.clientConfiguration, getPlatformApplicationAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SNS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPlatformApplicationAttributes");
            GetPlatformApplicationAttributesResponse getPlatformApplicationAttributesResponse = (GetPlatformApplicationAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPlatformApplicationAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getPlatformApplicationAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPlatformApplicationAttributesRequestMarshaller(this.protocolFactory)));
            return getPlatformApplicationAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnsClient.lambda$getPlatformApplicationAttributes$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSmsAttributesResponse getSMSAttributes(GetSmsAttributesRequest getSmsAttributesRequest) throws ThrottledException, InternalErrorException, AuthorizationErrorException, InvalidParameterException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetSmsAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSnsClient.resolveMetricPublishers(this.clientConfiguration, getSmsAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SNS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSMSAttributes");
            GetSmsAttributesResponse getSmsAttributesResponse = (GetSmsAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSMSAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSmsAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSmsAttributesRequestMarshaller(this.protocolFactory)));
            return getSmsAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnsClient.lambda$getSMSAttributes$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSmsSandboxAccountStatusResponse getSMSSandboxAccountStatus(GetSmsSandboxAccountStatusRequest getSmsSandboxAccountStatusRequest) throws AuthorizationErrorException, InternalErrorException, ThrottledException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetSmsSandboxAccountStatusResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSnsClient.resolveMetricPublishers(this.clientConfiguration, getSmsSandboxAccountStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SNS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSMSSandboxAccountStatus");
            GetSmsSandboxAccountStatusResponse getSmsSandboxAccountStatusResponse = (GetSmsSandboxAccountStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSMSSandboxAccountStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSmsSandboxAccountStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSmsSandboxAccountStatusRequestMarshaller(this.protocolFactory)));
            return getSmsSandboxAccountStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnsClient.lambda$getSMSSandboxAccountStatus$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSubscriptionAttributesResponse getSubscriptionAttributes(GetSubscriptionAttributesRequest getSubscriptionAttributesRequest) throws InvalidParameterException, InternalErrorException, NotFoundException, AuthorizationErrorException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetSubscriptionAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSnsClient.resolveMetricPublishers(this.clientConfiguration, getSubscriptionAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SNS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSubscriptionAttributes");
            GetSubscriptionAttributesResponse getSubscriptionAttributesResponse = (GetSubscriptionAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSubscriptionAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSubscriptionAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSubscriptionAttributesRequestMarshaller(this.protocolFactory)));
            return getSubscriptionAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnsClient.lambda$getSubscriptionAttributes$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTopicAttributesResponse getTopicAttributes(GetTopicAttributesRequest getTopicAttributesRequest) throws InvalidParameterException, InternalErrorException, NotFoundException, AuthorizationErrorException, InvalidSecurityException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetTopicAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSnsClient.resolveMetricPublishers(this.clientConfiguration, getTopicAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SNS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTopicAttributes");
            GetTopicAttributesResponse getTopicAttributesResponse = (GetTopicAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTopicAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getTopicAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTopicAttributesRequestMarshaller(this.protocolFactory)));
            return getTopicAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnsClient.lambda$getTopicAttributes$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEndpointsByPlatformApplicationResponse listEndpointsByPlatformApplication(ListEndpointsByPlatformApplicationRequest listEndpointsByPlatformApplicationRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, NotFoundException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListEndpointsByPlatformApplicationResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSnsClient.resolveMetricPublishers(this.clientConfiguration, listEndpointsByPlatformApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SNS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEndpointsByPlatformApplication");
            ListEndpointsByPlatformApplicationResponse listEndpointsByPlatformApplicationResponse = (ListEndpointsByPlatformApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEndpointsByPlatformApplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listEndpointsByPlatformApplicationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListEndpointsByPlatformApplicationRequestMarshaller(this.protocolFactory)));
            return listEndpointsByPlatformApplicationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnsClient.lambda$listEndpointsByPlatformApplication$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListEndpointsByPlatformApplicationIterable listEndpointsByPlatformApplicationPaginator(ListEndpointsByPlatformApplicationRequest listEndpointsByPlatformApplicationRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, NotFoundException, AwsServiceException, SdkClientException, SnsException {
        return new ListEndpointsByPlatformApplicationIterable(this, this.applyPaginatorUserAgent(listEndpointsByPlatformApplicationRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListOriginationNumbersResponse listOriginationNumbers(ListOriginationNumbersRequest listOriginationNumbersRequest) throws InternalErrorException, AuthorizationErrorException, ThrottledException, InvalidParameterException, ValidationException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListOriginationNumbersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSnsClient.resolveMetricPublishers(this.clientConfiguration, listOriginationNumbersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SNS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListOriginationNumbers");
            ListOriginationNumbersResponse listOriginationNumbersResponse = (ListOriginationNumbersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListOriginationNumbers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listOriginationNumbersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListOriginationNumbersRequestMarshaller(this.protocolFactory)));
            return listOriginationNumbersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnsClient.lambda$listOriginationNumbers$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListOriginationNumbersIterable listOriginationNumbersPaginator(ListOriginationNumbersRequest listOriginationNumbersRequest) throws InternalErrorException, AuthorizationErrorException, ThrottledException, InvalidParameterException, ValidationException, AwsServiceException, SdkClientException, SnsException {
        return new ListOriginationNumbersIterable(this, this.applyPaginatorUserAgent(listOriginationNumbersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPhoneNumbersOptedOutResponse listPhoneNumbersOptedOut(ListPhoneNumbersOptedOutRequest listPhoneNumbersOptedOutRequest) throws ThrottledException, InternalErrorException, AuthorizationErrorException, InvalidParameterException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListPhoneNumbersOptedOutResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSnsClient.resolveMetricPublishers(this.clientConfiguration, listPhoneNumbersOptedOutRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SNS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPhoneNumbersOptedOut");
            ListPhoneNumbersOptedOutResponse listPhoneNumbersOptedOutResponse = (ListPhoneNumbersOptedOutResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPhoneNumbersOptedOut").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPhoneNumbersOptedOutRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPhoneNumbersOptedOutRequestMarshaller(this.protocolFactory)));
            return listPhoneNumbersOptedOutResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnsClient.lambda$listPhoneNumbersOptedOut$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListPhoneNumbersOptedOutIterable listPhoneNumbersOptedOutPaginator(ListPhoneNumbersOptedOutRequest listPhoneNumbersOptedOutRequest) throws ThrottledException, InternalErrorException, AuthorizationErrorException, InvalidParameterException, AwsServiceException, SdkClientException, SnsException {
        return new ListPhoneNumbersOptedOutIterable(this, this.applyPaginatorUserAgent(listPhoneNumbersOptedOutRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPlatformApplicationsResponse listPlatformApplications(ListPlatformApplicationsRequest listPlatformApplicationsRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListPlatformApplicationsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSnsClient.resolveMetricPublishers(this.clientConfiguration, listPlatformApplicationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SNS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPlatformApplications");
            ListPlatformApplicationsResponse listPlatformApplicationsResponse = (ListPlatformApplicationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPlatformApplications").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPlatformApplicationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPlatformApplicationsRequestMarshaller(this.protocolFactory)));
            return listPlatformApplicationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnsClient.lambda$listPlatformApplications$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListPlatformApplicationsIterable listPlatformApplicationsPaginator(ListPlatformApplicationsRequest listPlatformApplicationsRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, AwsServiceException, SdkClientException, SnsException {
        return new ListPlatformApplicationsIterable(this, this.applyPaginatorUserAgent(listPlatformApplicationsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSmsSandboxPhoneNumbersResponse listSMSSandboxPhoneNumbers(ListSmsSandboxPhoneNumbersRequest listSmsSandboxPhoneNumbersRequest) throws AuthorizationErrorException, InternalErrorException, InvalidParameterException, ResourceNotFoundException, ThrottledException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListSmsSandboxPhoneNumbersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSnsClient.resolveMetricPublishers(this.clientConfiguration, listSmsSandboxPhoneNumbersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SNS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSMSSandboxPhoneNumbers");
            ListSmsSandboxPhoneNumbersResponse listSmsSandboxPhoneNumbersResponse = (ListSmsSandboxPhoneNumbersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSMSSandboxPhoneNumbers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSmsSandboxPhoneNumbersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSmsSandboxPhoneNumbersRequestMarshaller(this.protocolFactory)));
            return listSmsSandboxPhoneNumbersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnsClient.lambda$listSMSSandboxPhoneNumbers$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListSMSSandboxPhoneNumbersIterable listSMSSandboxPhoneNumbersPaginator(ListSmsSandboxPhoneNumbersRequest listSmsSandboxPhoneNumbersRequest) throws AuthorizationErrorException, InternalErrorException, InvalidParameterException, ResourceNotFoundException, ThrottledException, AwsServiceException, SdkClientException, SnsException {
        return new ListSMSSandboxPhoneNumbersIterable(this, this.applyPaginatorUserAgent(listSmsSandboxPhoneNumbersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSubscriptionsResponse listSubscriptions(ListSubscriptionsRequest listSubscriptionsRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListSubscriptionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSnsClient.resolveMetricPublishers(this.clientConfiguration, listSubscriptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SNS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSubscriptions");
            ListSubscriptionsResponse listSubscriptionsResponse = (ListSubscriptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSubscriptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSubscriptionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSubscriptionsRequestMarshaller(this.protocolFactory)));
            return listSubscriptionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnsClient.lambda$listSubscriptions$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListSubscriptionsIterable listSubscriptionsPaginator(ListSubscriptionsRequest listSubscriptionsRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, AwsServiceException, SdkClientException, SnsException {
        return new ListSubscriptionsIterable(this, this.applyPaginatorUserAgent(listSubscriptionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSubscriptionsByTopicResponse listSubscriptionsByTopic(ListSubscriptionsByTopicRequest listSubscriptionsByTopicRequest) throws InvalidParameterException, InternalErrorException, NotFoundException, AuthorizationErrorException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListSubscriptionsByTopicResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSnsClient.resolveMetricPublishers(this.clientConfiguration, listSubscriptionsByTopicRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SNS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSubscriptionsByTopic");
            ListSubscriptionsByTopicResponse listSubscriptionsByTopicResponse = (ListSubscriptionsByTopicResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSubscriptionsByTopic").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSubscriptionsByTopicRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSubscriptionsByTopicRequestMarshaller(this.protocolFactory)));
            return listSubscriptionsByTopicResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnsClient.lambda$listSubscriptionsByTopic$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListSubscriptionsByTopicIterable listSubscriptionsByTopicPaginator(ListSubscriptionsByTopicRequest listSubscriptionsByTopicRequest) throws InvalidParameterException, InternalErrorException, NotFoundException, AuthorizationErrorException, AwsServiceException, SdkClientException, SnsException {
        return new ListSubscriptionsByTopicIterable(this, this.applyPaginatorUserAgent(listSubscriptionsByTopicRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, TagPolicyException, InvalidParameterException, AuthorizationErrorException, ConcurrentAccessException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListTagsForResourceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSnsClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SNS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller(this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnsClient.lambda$listTagsForResource$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTopicsResponse listTopics(ListTopicsRequest listTopicsRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListTopicsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSnsClient.resolveMetricPublishers(this.clientConfiguration, listTopicsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SNS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTopics");
            ListTopicsResponse listTopicsResponse = (ListTopicsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTopics").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTopicsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTopicsRequestMarshaller(this.protocolFactory)));
            return listTopicsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnsClient.lambda$listTopics$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListTopicsIterable listTopicsPaginator(ListTopicsRequest listTopicsRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, AwsServiceException, SdkClientException, SnsException {
        return new ListTopicsIterable(this, this.applyPaginatorUserAgent(listTopicsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OptInPhoneNumberResponse optInPhoneNumber(OptInPhoneNumberRequest optInPhoneNumberRequest) throws ThrottledException, InternalErrorException, AuthorizationErrorException, InvalidParameterException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(OptInPhoneNumberResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSnsClient.resolveMetricPublishers(this.clientConfiguration, optInPhoneNumberRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SNS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"OptInPhoneNumber");
            OptInPhoneNumberResponse optInPhoneNumberResponse = (OptInPhoneNumberResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("OptInPhoneNumber").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)optInPhoneNumberRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new OptInPhoneNumberRequestMarshaller(this.protocolFactory)));
            return optInPhoneNumberResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnsClient.lambda$optInPhoneNumber$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PublishResponse publish(PublishRequest publishRequest) throws InvalidParameterException, InvalidParameterValueException, InternalErrorException, NotFoundException, EndpointDisabledException, PlatformApplicationDisabledException, AuthorizationErrorException, KmsDisabledException, KmsInvalidStateException, KmsNotFoundException, KmsOptInRequiredException, KmsThrottlingException, KmsAccessDeniedException, InvalidSecurityException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PublishResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSnsClient.resolveMetricPublishers(this.clientConfiguration, publishRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SNS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"Publish");
            PublishResponse publishResponse = (PublishResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("Publish").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)publishRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PublishRequestMarshaller(this.protocolFactory)));
            return publishResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnsClient.lambda$publish$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PublishBatchResponse publishBatch(PublishBatchRequest publishBatchRequest) throws InvalidParameterException, InvalidParameterValueException, InternalErrorException, NotFoundException, EndpointDisabledException, PlatformApplicationDisabledException, AuthorizationErrorException, BatchEntryIdsNotDistinctException, BatchRequestTooLongException, EmptyBatchRequestException, InvalidBatchEntryIdException, TooManyEntriesInBatchRequestException, KmsDisabledException, KmsInvalidStateException, KmsNotFoundException, KmsOptInRequiredException, KmsThrottlingException, KmsAccessDeniedException, InvalidSecurityException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PublishBatchResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSnsClient.resolveMetricPublishers(this.clientConfiguration, publishBatchRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SNS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PublishBatch");
            PublishBatchResponse publishBatchResponse = (PublishBatchResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PublishBatch").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)publishBatchRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PublishBatchRequestMarshaller(this.protocolFactory)));
            return publishBatchResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnsClient.lambda$publishBatch$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemovePermissionResponse removePermission(RemovePermissionRequest removePermissionRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, NotFoundException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RemovePermissionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSnsClient.resolveMetricPublishers(this.clientConfiguration, removePermissionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SNS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemovePermission");
            RemovePermissionResponse removePermissionResponse = (RemovePermissionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemovePermission").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removePermissionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RemovePermissionRequestMarshaller(this.protocolFactory)));
            return removePermissionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnsClient.lambda$removePermission$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetEndpointAttributesResponse setEndpointAttributes(SetEndpointAttributesRequest setEndpointAttributesRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, NotFoundException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetEndpointAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSnsClient.resolveMetricPublishers(this.clientConfiguration, setEndpointAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SNS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetEndpointAttributes");
            SetEndpointAttributesResponse setEndpointAttributesResponse = (SetEndpointAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetEndpointAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setEndpointAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SetEndpointAttributesRequestMarshaller(this.protocolFactory)));
            return setEndpointAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnsClient.lambda$setEndpointAttributes$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetPlatformApplicationAttributesResponse setPlatformApplicationAttributes(SetPlatformApplicationAttributesRequest setPlatformApplicationAttributesRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, NotFoundException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetPlatformApplicationAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSnsClient.resolveMetricPublishers(this.clientConfiguration, setPlatformApplicationAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SNS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetPlatformApplicationAttributes");
            SetPlatformApplicationAttributesResponse setPlatformApplicationAttributesResponse = (SetPlatformApplicationAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetPlatformApplicationAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setPlatformApplicationAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SetPlatformApplicationAttributesRequestMarshaller(this.protocolFactory)));
            return setPlatformApplicationAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnsClient.lambda$setPlatformApplicationAttributes$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetSmsAttributesResponse setSMSAttributes(SetSmsAttributesRequest setSmsAttributesRequest) throws InvalidParameterException, ThrottledException, InternalErrorException, AuthorizationErrorException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetSmsAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSnsClient.resolveMetricPublishers(this.clientConfiguration, setSmsAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SNS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetSMSAttributes");
            SetSmsAttributesResponse setSmsAttributesResponse = (SetSmsAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetSMSAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setSmsAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SetSmsAttributesRequestMarshaller(this.protocolFactory)));
            return setSmsAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnsClient.lambda$setSMSAttributes$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetSubscriptionAttributesResponse setSubscriptionAttributes(SetSubscriptionAttributesRequest setSubscriptionAttributesRequest) throws InvalidParameterException, FilterPolicyLimitExceededException, InternalErrorException, NotFoundException, AuthorizationErrorException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetSubscriptionAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSnsClient.resolveMetricPublishers(this.clientConfiguration, setSubscriptionAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SNS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetSubscriptionAttributes");
            SetSubscriptionAttributesResponse setSubscriptionAttributesResponse = (SetSubscriptionAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetSubscriptionAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setSubscriptionAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SetSubscriptionAttributesRequestMarshaller(this.protocolFactory)));
            return setSubscriptionAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnsClient.lambda$setSubscriptionAttributes$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetTopicAttributesResponse setTopicAttributes(SetTopicAttributesRequest setTopicAttributesRequest) throws InvalidParameterException, InternalErrorException, NotFoundException, AuthorizationErrorException, InvalidSecurityException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetTopicAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSnsClient.resolveMetricPublishers(this.clientConfiguration, setTopicAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SNS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetTopicAttributes");
            SetTopicAttributesResponse setTopicAttributesResponse = (SetTopicAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetTopicAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setTopicAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SetTopicAttributesRequestMarshaller(this.protocolFactory)));
            return setTopicAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnsClient.lambda$setTopicAttributes$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubscribeResponse subscribe(SubscribeRequest subscribeRequest) throws SubscriptionLimitExceededException, FilterPolicyLimitExceededException, InvalidParameterException, InternalErrorException, NotFoundException, AuthorizationErrorException, InvalidSecurityException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SubscribeResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSnsClient.resolveMetricPublishers(this.clientConfiguration, subscribeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SNS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"Subscribe");
            SubscribeResponse subscribeResponse = (SubscribeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("Subscribe").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)subscribeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SubscribeRequestMarshaller(this.protocolFactory)));
            return subscribeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnsClient.lambda$subscribe$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException, TagLimitExceededException, StaleTagException, TagPolicyException, InvalidParameterException, AuthorizationErrorException, ConcurrentAccessException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(TagResourceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSnsClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SNS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller(this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnsClient.lambda$tagResource$36((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UnsubscribeResponse unsubscribe(UnsubscribeRequest unsubscribeRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, NotFoundException, InvalidSecurityException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UnsubscribeResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSnsClient.resolveMetricPublishers(this.clientConfiguration, unsubscribeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SNS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"Unsubscribe");
            UnsubscribeResponse unsubscribeResponse = (UnsubscribeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("Unsubscribe").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)unsubscribeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UnsubscribeRequestMarshaller(this.protocolFactory)));
            return unsubscribeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnsClient.lambda$unsubscribe$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException, TagLimitExceededException, StaleTagException, TagPolicyException, InvalidParameterException, AuthorizationErrorException, ConcurrentAccessException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UntagResourceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSnsClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SNS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller(this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnsClient.lambda$untagResource$38((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VerifySmsSandboxPhoneNumberResponse verifySMSSandboxPhoneNumber(VerifySmsSandboxPhoneNumberRequest verifySmsSandboxPhoneNumberRequest) throws AuthorizationErrorException, InternalErrorException, InvalidParameterException, ResourceNotFoundException, VerificationException, ThrottledException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(VerifySmsSandboxPhoneNumberResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultSnsClient.resolveMetricPublishers(this.clientConfiguration, verifySmsSandboxPhoneNumberRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SNS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"VerifySMSSandboxPhoneNumber");
            VerifySmsSandboxPhoneNumberResponse verifySmsSandboxPhoneNumberResponse = (VerifySmsSandboxPhoneNumberResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("VerifySMSSandboxPhoneNumber").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)verifySmsSandboxPhoneNumberRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new VerifySmsSandboxPhoneNumberRequestMarshaller(this.protocolFactory)));
            return verifySmsSandboxPhoneNumberResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSnsClient.lambda$verifySMSSandboxPhoneNumber$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("SubscriptionLimitExceeded").exceptionBuilderSupplier(SubscriptionLimitExceededException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("KMSThrottling").exceptionBuilderSupplier(KmsThrottlingException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParameter").exceptionBuilderSupplier(InvalidParameterException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BatchEntryIdsNotDistinct").exceptionBuilderSupplier(BatchEntryIdsNotDistinctException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ParameterValueInvalid").exceptionBuilderSupplier(InvalidParameterValueException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EndpointDisabled").exceptionBuilderSupplier(EndpointDisabledException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FilterPolicyLimitExceeded").exceptionBuilderSupplier(FilterPolicyLimitExceededException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("KMSInvalidState").exceptionBuilderSupplier(KmsInvalidStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("KMSNotFound").exceptionBuilderSupplier(KmsNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UserError").exceptionBuilderSupplier(UserErrorException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("KMSOptInRequired").exceptionBuilderSupplier(KmsOptInRequiredException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("StaleTag").exceptionBuilderSupplier(StaleTagException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotFound").exceptionBuilderSupplier(NotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("VerificationException").exceptionBuilderSupplier(VerificationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("Throttled").exceptionBuilderSupplier(ThrottledException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalError").exceptionBuilderSupplier(InternalErrorException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EmptyBatchRequest").exceptionBuilderSupplier(EmptyBatchRequestException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSecurity").exceptionBuilderSupplier(InvalidSecurityException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OptedOut").exceptionBuilderSupplier(OptedOutException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyEntriesInBatchRequest").exceptionBuilderSupplier(TooManyEntriesInBatchRequestException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFound").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BatchRequestTooLong").exceptionBuilderSupplier(BatchRequestTooLongException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("KMSAccessDenied").exceptionBuilderSupplier(KmsAccessDeniedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("KMSDisabled").exceptionBuilderSupplier(KmsDisabledException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TopicLimitExceeded").exceptionBuilderSupplier(TopicLimitExceededException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TagPolicy").exceptionBuilderSupplier(TagPolicyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TagLimitExceeded").exceptionBuilderSupplier(TagLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PlatformApplicationDisabled").exceptionBuilderSupplier(PlatformApplicationDisabledException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AuthorizationError").exceptionBuilderSupplier(AuthorizationErrorException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConcurrentAccess").exceptionBuilderSupplier(ConcurrentAccessException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidBatchEntryId").exceptionBuilderSupplier(InvalidBatchEntryIdException::builder).httpStatusCode(Integer.valueOf(400)).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(SnsException::builder).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends SnsRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.17.252").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((SnsRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$verifySMSSandboxPhoneNumber$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$unsubscribe$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$36(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$subscribe$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setTopicAttributes$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setSubscriptionAttributes$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setSMSAttributes$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setPlatformApplicationAttributes$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setEndpointAttributes$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removePermission$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$publishBatch$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$publish$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$optInPhoneNumber$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTopics$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSubscriptionsByTopic$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSubscriptions$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSMSSandboxPhoneNumbers$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPlatformApplications$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPhoneNumbersOptedOut$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listOriginationNumbers$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEndpointsByPlatformApplication$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTopicAttributes$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSubscriptionAttributes$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSMSSandboxAccountStatus$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSMSAttributes$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPlatformApplicationAttributes$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getEndpointAttributes$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTopic$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSMSSandboxPhoneNumber$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePlatformApplication$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteEndpoint$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTopic$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSMSSandboxPhoneNumber$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPlatformEndpoint$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPlatformApplication$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$confirmSubscription$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$checkIfPhoneNumberIsOptedOut$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addPermission$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

