/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum RouteType {
    TRANSACTIONAL("Transactional"),
    PROMOTIONAL("Promotional"),
    PREMIUM("Premium"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private RouteType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RouteType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(RouteType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RouteType> knownValues() {
        return Stream.of(RouteType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

