/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sns.model.SnsResponse;
import software.amazon.awssdk.services.sns.model.Subscription;
import software.amazon.awssdk.services.sns.model.SubscriptionsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSubscriptionsResponse
extends SnsResponse
implements ToCopyableBuilder<Builder, ListSubscriptionsResponse> {
    private static final SdkField<List<Subscription>> SUBSCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Subscriptions").getter(ListSubscriptionsResponse.getter(ListSubscriptionsResponse::subscriptions)).setter(ListSubscriptionsResponse.setter(Builder::subscriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subscriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Subscription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListSubscriptionsResponse.getter(ListSubscriptionsResponse::nextToken)).setter(ListSubscriptionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBSCRIPTIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Subscription> subscriptions;
    private final String nextToken;

    private ListSubscriptionsResponse(BuilderImpl builder) {
        super(builder);
        this.subscriptions = builder.subscriptions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSubscriptions() {
        return this.subscriptions != null && !(this.subscriptions instanceof SdkAutoConstructList);
    }

    public final List<Subscription> subscriptions() {
        return this.subscriptions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubscriptions() ? this.subscriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSubscriptionsResponse)) {
            return false;
        }
        ListSubscriptionsResponse other = (ListSubscriptionsResponse)((Object)obj);
        return this.hasSubscriptions() == other.hasSubscriptions() && Objects.equals(this.subscriptions(), other.subscriptions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSubscriptionsResponse").add("Subscriptions", this.hasSubscriptions() ? this.subscriptions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Subscriptions": {
                return Optional.ofNullable(clazz.cast(this.subscriptions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSubscriptionsResponse, T> g) {
        return obj -> g.apply((ListSubscriptionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SnsResponse.BuilderImpl
    implements Builder {
        private List<Subscription> subscriptions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSubscriptionsResponse model) {
            super(model);
            this.subscriptions(model.subscriptions);
            this.nextToken(model.nextToken);
        }

        public final List<Subscription.Builder> getSubscriptions() {
            List<Subscription.Builder> result = SubscriptionsListCopier.copyToBuilder(this.subscriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubscriptions(Collection<Subscription.BuilderImpl> subscriptions) {
            this.subscriptions = SubscriptionsListCopier.copyFromBuilder(subscriptions);
        }

        @Override
        @Transient
        public final Builder subscriptions(Collection<Subscription> subscriptions) {
            this.subscriptions = SubscriptionsListCopier.copy(subscriptions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subscriptions(Subscription ... subscriptions) {
            this.subscriptions(Arrays.asList(subscriptions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subscriptions(Consumer<Subscription.Builder> ... subscriptions) {
            this.subscriptions(Stream.of(subscriptions).map(c -> (Subscription)((Subscription.Builder)Subscription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSubscriptionsResponse build() {
            return new ListSubscriptionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SnsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSubscriptionsResponse> {
        public Builder subscriptions(Collection<Subscription> var1);

        public Builder subscriptions(Subscription ... var1);

        public Builder subscriptions(Consumer<Subscription.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

