/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sns.SnsAsyncClient;
import software.amazon.awssdk.services.sns.model.ListOriginationNumbersRequest;
import software.amazon.awssdk.services.sns.model.ListOriginationNumbersResponse;
import software.amazon.awssdk.services.sns.model.PhoneNumberInformation;

public class ListOriginationNumbersPublisher
implements SdkPublisher<ListOriginationNumbersResponse> {
    private final SnsAsyncClient client;
    private final ListOriginationNumbersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListOriginationNumbersPublisher(SnsAsyncClient client, ListOriginationNumbersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListOriginationNumbersPublisher(SnsAsyncClient client, ListOriginationNumbersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListOriginationNumbersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListOriginationNumbersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PhoneNumberInformation> phoneNumbers() {
        Function<ListOriginationNumbersResponse, Iterator> getIterator = response -> {
            if (response != null && response.phoneNumbers() != null) {
                return response.phoneNumbers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListOriginationNumbersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListOriginationNumbersResponseFetcher
    implements AsyncPageFetcher<ListOriginationNumbersResponse> {
        private ListOriginationNumbersResponseFetcher() {
        }

        public boolean hasNextPage(ListOriginationNumbersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListOriginationNumbersResponse> nextPage(ListOriginationNumbersResponse previousPage) {
            if (previousPage == null) {
                return ListOriginationNumbersPublisher.this.client.listOriginationNumbers(ListOriginationNumbersPublisher.this.firstRequest);
            }
            return ListOriginationNumbersPublisher.this.client.listOriginationNumbers((ListOriginationNumbersRequest)((Object)ListOriginationNumbersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

