/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.services.sns.SnsClient;
import software.amazon.awssdk.services.sns.model.AddPermissionRequest;
import software.amazon.awssdk.services.sns.model.AddPermissionResponse;
import software.amazon.awssdk.services.sns.model.AuthorizationErrorException;
import software.amazon.awssdk.services.sns.model.CheckIfPhoneNumberIsOptedOutRequest;
import software.amazon.awssdk.services.sns.model.CheckIfPhoneNumberIsOptedOutResponse;
import software.amazon.awssdk.services.sns.model.ConcurrentAccessException;
import software.amazon.awssdk.services.sns.model.ConfirmSubscriptionRequest;
import software.amazon.awssdk.services.sns.model.ConfirmSubscriptionResponse;
import software.amazon.awssdk.services.sns.model.CreatePlatformApplicationRequest;
import software.amazon.awssdk.services.sns.model.CreatePlatformApplicationResponse;
import software.amazon.awssdk.services.sns.model.CreatePlatformEndpointRequest;
import software.amazon.awssdk.services.sns.model.CreatePlatformEndpointResponse;
import software.amazon.awssdk.services.sns.model.CreateTopicRequest;
import software.amazon.awssdk.services.sns.model.CreateTopicResponse;
import software.amazon.awssdk.services.sns.model.DeleteEndpointRequest;
import software.amazon.awssdk.services.sns.model.DeleteEndpointResponse;
import software.amazon.awssdk.services.sns.model.DeletePlatformApplicationRequest;
import software.amazon.awssdk.services.sns.model.DeletePlatformApplicationResponse;
import software.amazon.awssdk.services.sns.model.DeleteTopicRequest;
import software.amazon.awssdk.services.sns.model.DeleteTopicResponse;
import software.amazon.awssdk.services.sns.model.EndpointDisabledException;
import software.amazon.awssdk.services.sns.model.FilterPolicyLimitExceededException;
import software.amazon.awssdk.services.sns.model.GetEndpointAttributesRequest;
import software.amazon.awssdk.services.sns.model.GetEndpointAttributesResponse;
import software.amazon.awssdk.services.sns.model.GetPlatformApplicationAttributesRequest;
import software.amazon.awssdk.services.sns.model.GetPlatformApplicationAttributesResponse;
import software.amazon.awssdk.services.sns.model.GetSmsAttributesRequest;
import software.amazon.awssdk.services.sns.model.GetSmsAttributesResponse;
import software.amazon.awssdk.services.sns.model.GetSubscriptionAttributesRequest;
import software.amazon.awssdk.services.sns.model.GetSubscriptionAttributesResponse;
import software.amazon.awssdk.services.sns.model.GetTopicAttributesRequest;
import software.amazon.awssdk.services.sns.model.GetTopicAttributesResponse;
import software.amazon.awssdk.services.sns.model.InternalErrorException;
import software.amazon.awssdk.services.sns.model.InvalidParameterException;
import software.amazon.awssdk.services.sns.model.InvalidParameterValueException;
import software.amazon.awssdk.services.sns.model.InvalidSecurityException;
import software.amazon.awssdk.services.sns.model.KmsAccessDeniedException;
import software.amazon.awssdk.services.sns.model.KmsDisabledException;
import software.amazon.awssdk.services.sns.model.KmsInvalidStateException;
import software.amazon.awssdk.services.sns.model.KmsNotFoundException;
import software.amazon.awssdk.services.sns.model.KmsOptInRequiredException;
import software.amazon.awssdk.services.sns.model.KmsThrottlingException;
import software.amazon.awssdk.services.sns.model.ListEndpointsByPlatformApplicationRequest;
import software.amazon.awssdk.services.sns.model.ListEndpointsByPlatformApplicationResponse;
import software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutRequest;
import software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutResponse;
import software.amazon.awssdk.services.sns.model.ListPlatformApplicationsRequest;
import software.amazon.awssdk.services.sns.model.ListPlatformApplicationsResponse;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicRequest;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicResponse;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsRequest;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsResponse;
import software.amazon.awssdk.services.sns.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.sns.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.sns.model.ListTopicsRequest;
import software.amazon.awssdk.services.sns.model.ListTopicsResponse;
import software.amazon.awssdk.services.sns.model.NotFoundException;
import software.amazon.awssdk.services.sns.model.OptInPhoneNumberRequest;
import software.amazon.awssdk.services.sns.model.OptInPhoneNumberResponse;
import software.amazon.awssdk.services.sns.model.PlatformApplicationDisabledException;
import software.amazon.awssdk.services.sns.model.PublishRequest;
import software.amazon.awssdk.services.sns.model.PublishResponse;
import software.amazon.awssdk.services.sns.model.RemovePermissionRequest;
import software.amazon.awssdk.services.sns.model.RemovePermissionResponse;
import software.amazon.awssdk.services.sns.model.ResourceNotFoundException;
import software.amazon.awssdk.services.sns.model.SetEndpointAttributesRequest;
import software.amazon.awssdk.services.sns.model.SetEndpointAttributesResponse;
import software.amazon.awssdk.services.sns.model.SetPlatformApplicationAttributesRequest;
import software.amazon.awssdk.services.sns.model.SetPlatformApplicationAttributesResponse;
import software.amazon.awssdk.services.sns.model.SetSmsAttributesRequest;
import software.amazon.awssdk.services.sns.model.SetSmsAttributesResponse;
import software.amazon.awssdk.services.sns.model.SetSubscriptionAttributesRequest;
import software.amazon.awssdk.services.sns.model.SetSubscriptionAttributesResponse;
import software.amazon.awssdk.services.sns.model.SetTopicAttributesRequest;
import software.amazon.awssdk.services.sns.model.SetTopicAttributesResponse;
import software.amazon.awssdk.services.sns.model.SnsException;
import software.amazon.awssdk.services.sns.model.SnsRequest;
import software.amazon.awssdk.services.sns.model.StaleTagException;
import software.amazon.awssdk.services.sns.model.SubscribeRequest;
import software.amazon.awssdk.services.sns.model.SubscribeResponse;
import software.amazon.awssdk.services.sns.model.SubscriptionLimitExceededException;
import software.amazon.awssdk.services.sns.model.TagLimitExceededException;
import software.amazon.awssdk.services.sns.model.TagPolicyException;
import software.amazon.awssdk.services.sns.model.TagResourceRequest;
import software.amazon.awssdk.services.sns.model.TagResourceResponse;
import software.amazon.awssdk.services.sns.model.ThrottledException;
import software.amazon.awssdk.services.sns.model.TopicLimitExceededException;
import software.amazon.awssdk.services.sns.model.UnsubscribeRequest;
import software.amazon.awssdk.services.sns.model.UnsubscribeResponse;
import software.amazon.awssdk.services.sns.model.UntagResourceRequest;
import software.amazon.awssdk.services.sns.model.UntagResourceResponse;
import software.amazon.awssdk.services.sns.paginators.ListEndpointsByPlatformApplicationIterable;
import software.amazon.awssdk.services.sns.paginators.ListPlatformApplicationsIterable;
import software.amazon.awssdk.services.sns.paginators.ListSubscriptionsByTopicIterable;
import software.amazon.awssdk.services.sns.paginators.ListSubscriptionsIterable;
import software.amazon.awssdk.services.sns.paginators.ListTopicsIterable;
import software.amazon.awssdk.services.sns.transform.AddPermissionRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.CheckIfPhoneNumberIsOptedOutRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.ConfirmSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.CreatePlatformApplicationRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.CreatePlatformEndpointRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.CreateTopicRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.DeleteEndpointRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.DeletePlatformApplicationRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.DeleteTopicRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.GetEndpointAttributesRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.GetPlatformApplicationAttributesRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.GetSmsAttributesRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.GetSubscriptionAttributesRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.GetTopicAttributesRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.ListEndpointsByPlatformApplicationRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.ListPhoneNumbersOptedOutRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.ListPlatformApplicationsRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.ListSubscriptionsByTopicRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.ListSubscriptionsRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.ListTopicsRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.OptInPhoneNumberRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.PublishRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.RemovePermissionRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.SetEndpointAttributesRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.SetPlatformApplicationAttributesRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.SetSmsAttributesRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.SetSubscriptionAttributesRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.SetTopicAttributesRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.SubscribeRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.UnsubscribeRequestMarshaller;
import software.amazon.awssdk.services.sns.transform.UntagResourceRequestMarshaller;

@SdkInternalApi
final class DefaultSnsClient
implements SnsClient {
    private final SyncClientHandler clientHandler;
    private final AwsQueryProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultSnsClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "sns";
    }

    @Override
    public AddPermissionResponse addPermission(AddPermissionRequest addPermissionRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, NotFoundException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AddPermissionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (AddPermissionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddPermission").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addPermissionRequest).withMarshaller((Marshaller)new AddPermissionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CheckIfPhoneNumberIsOptedOutResponse checkIfPhoneNumberIsOptedOut(CheckIfPhoneNumberIsOptedOutRequest checkIfPhoneNumberIsOptedOutRequest) throws ThrottledException, InternalErrorException, AuthorizationErrorException, InvalidParameterException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CheckIfPhoneNumberIsOptedOutResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CheckIfPhoneNumberIsOptedOutResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CheckIfPhoneNumberIsOptedOut").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)checkIfPhoneNumberIsOptedOutRequest).withMarshaller((Marshaller)new CheckIfPhoneNumberIsOptedOutRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ConfirmSubscriptionResponse confirmSubscription(ConfirmSubscriptionRequest confirmSubscriptionRequest) throws SubscriptionLimitExceededException, InvalidParameterException, NotFoundException, InternalErrorException, AuthorizationErrorException, FilterPolicyLimitExceededException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ConfirmSubscriptionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ConfirmSubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ConfirmSubscription").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)confirmSubscriptionRequest).withMarshaller((Marshaller)new ConfirmSubscriptionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreatePlatformApplicationResponse createPlatformApplication(CreatePlatformApplicationRequest createPlatformApplicationRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreatePlatformApplicationResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreatePlatformApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePlatformApplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPlatformApplicationRequest).withMarshaller((Marshaller)new CreatePlatformApplicationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreatePlatformEndpointResponse createPlatformEndpoint(CreatePlatformEndpointRequest createPlatformEndpointRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, NotFoundException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreatePlatformEndpointResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreatePlatformEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePlatformEndpoint").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPlatformEndpointRequest).withMarshaller((Marshaller)new CreatePlatformEndpointRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateTopicResponse createTopic(CreateTopicRequest createTopicRequest) throws InvalidParameterException, TopicLimitExceededException, InternalErrorException, AuthorizationErrorException, InvalidSecurityException, TagLimitExceededException, StaleTagException, TagPolicyException, ConcurrentAccessException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateTopicResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateTopicResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTopic").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createTopicRequest).withMarshaller((Marshaller)new CreateTopicRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteEndpointResponse deleteEndpoint(DeleteEndpointRequest deleteEndpointRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteEndpointResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEndpoint").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteEndpointRequest).withMarshaller((Marshaller)new DeleteEndpointRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeletePlatformApplicationResponse deletePlatformApplication(DeletePlatformApplicationRequest deletePlatformApplicationRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeletePlatformApplicationResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeletePlatformApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePlatformApplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deletePlatformApplicationRequest).withMarshaller((Marshaller)new DeletePlatformApplicationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteTopicResponse deleteTopic(DeleteTopicRequest deleteTopicRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, NotFoundException, StaleTagException, TagPolicyException, ConcurrentAccessException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteTopicResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteTopicResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTopic").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteTopicRequest).withMarshaller((Marshaller)new DeleteTopicRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetEndpointAttributesResponse getEndpointAttributes(GetEndpointAttributesRequest getEndpointAttributesRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, NotFoundException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetEndpointAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (GetEndpointAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEndpointAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getEndpointAttributesRequest).withMarshaller((Marshaller)new GetEndpointAttributesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetPlatformApplicationAttributesResponse getPlatformApplicationAttributes(GetPlatformApplicationAttributesRequest getPlatformApplicationAttributesRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, NotFoundException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetPlatformApplicationAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (GetPlatformApplicationAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPlatformApplicationAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getPlatformApplicationAttributesRequest).withMarshaller((Marshaller)new GetPlatformApplicationAttributesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetSmsAttributesResponse getSMSAttributes(GetSmsAttributesRequest getSmsAttributesRequest) throws ThrottledException, InternalErrorException, AuthorizationErrorException, InvalidParameterException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetSmsAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (GetSmsAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSMSAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSmsAttributesRequest).withMarshaller((Marshaller)new GetSmsAttributesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetSubscriptionAttributesResponse getSubscriptionAttributes(GetSubscriptionAttributesRequest getSubscriptionAttributesRequest) throws InvalidParameterException, InternalErrorException, NotFoundException, AuthorizationErrorException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetSubscriptionAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (GetSubscriptionAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSubscriptionAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSubscriptionAttributesRequest).withMarshaller((Marshaller)new GetSubscriptionAttributesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetTopicAttributesResponse getTopicAttributes(GetTopicAttributesRequest getTopicAttributesRequest) throws InvalidParameterException, InternalErrorException, NotFoundException, AuthorizationErrorException, InvalidSecurityException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetTopicAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (GetTopicAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTopicAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getTopicAttributesRequest).withMarshaller((Marshaller)new GetTopicAttributesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListEndpointsByPlatformApplicationResponse listEndpointsByPlatformApplication(ListEndpointsByPlatformApplicationRequest listEndpointsByPlatformApplicationRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, NotFoundException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListEndpointsByPlatformApplicationResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListEndpointsByPlatformApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEndpointsByPlatformApplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listEndpointsByPlatformApplicationRequest).withMarshaller((Marshaller)new ListEndpointsByPlatformApplicationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListEndpointsByPlatformApplicationIterable listEndpointsByPlatformApplicationPaginator(ListEndpointsByPlatformApplicationRequest listEndpointsByPlatformApplicationRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, NotFoundException, AwsServiceException, SdkClientException, SnsException {
        return new ListEndpointsByPlatformApplicationIterable(this, this.applyPaginatorUserAgent(listEndpointsByPlatformApplicationRequest));
    }

    @Override
    public ListPhoneNumbersOptedOutResponse listPhoneNumbersOptedOut(ListPhoneNumbersOptedOutRequest listPhoneNumbersOptedOutRequest) throws ThrottledException, InternalErrorException, AuthorizationErrorException, InvalidParameterException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListPhoneNumbersOptedOutResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListPhoneNumbersOptedOutResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPhoneNumbersOptedOut").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPhoneNumbersOptedOutRequest).withMarshaller((Marshaller)new ListPhoneNumbersOptedOutRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListPlatformApplicationsResponse listPlatformApplications(ListPlatformApplicationsRequest listPlatformApplicationsRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListPlatformApplicationsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListPlatformApplicationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPlatformApplications").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPlatformApplicationsRequest).withMarshaller((Marshaller)new ListPlatformApplicationsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListPlatformApplicationsIterable listPlatformApplicationsPaginator(ListPlatformApplicationsRequest listPlatformApplicationsRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, AwsServiceException, SdkClientException, SnsException {
        return new ListPlatformApplicationsIterable(this, this.applyPaginatorUserAgent(listPlatformApplicationsRequest));
    }

    @Override
    public ListSubscriptionsResponse listSubscriptions(ListSubscriptionsRequest listSubscriptionsRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListSubscriptionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListSubscriptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSubscriptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSubscriptionsRequest).withMarshaller((Marshaller)new ListSubscriptionsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListSubscriptionsIterable listSubscriptionsPaginator(ListSubscriptionsRequest listSubscriptionsRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, AwsServiceException, SdkClientException, SnsException {
        return new ListSubscriptionsIterable(this, this.applyPaginatorUserAgent(listSubscriptionsRequest));
    }

    @Override
    public ListSubscriptionsByTopicResponse listSubscriptionsByTopic(ListSubscriptionsByTopicRequest listSubscriptionsByTopicRequest) throws InvalidParameterException, InternalErrorException, NotFoundException, AuthorizationErrorException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListSubscriptionsByTopicResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListSubscriptionsByTopicResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSubscriptionsByTopic").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSubscriptionsByTopicRequest).withMarshaller((Marshaller)new ListSubscriptionsByTopicRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListSubscriptionsByTopicIterable listSubscriptionsByTopicPaginator(ListSubscriptionsByTopicRequest listSubscriptionsByTopicRequest) throws InvalidParameterException, InternalErrorException, NotFoundException, AuthorizationErrorException, AwsServiceException, SdkClientException, SnsException {
        return new ListSubscriptionsByTopicIterable(this, this.applyPaginatorUserAgent(listSubscriptionsByTopicRequest));
    }

    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, TagPolicyException, InvalidParameterException, AuthorizationErrorException, ConcurrentAccessException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListTagsForResourceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListTopicsResponse listTopics(ListTopicsRequest listTopicsRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListTopicsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListTopicsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTopics").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTopicsRequest).withMarshaller((Marshaller)new ListTopicsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListTopicsIterable listTopicsPaginator(ListTopicsRequest listTopicsRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, AwsServiceException, SdkClientException, SnsException {
        return new ListTopicsIterable(this, this.applyPaginatorUserAgent(listTopicsRequest));
    }

    @Override
    public OptInPhoneNumberResponse optInPhoneNumber(OptInPhoneNumberRequest optInPhoneNumberRequest) throws ThrottledException, InternalErrorException, AuthorizationErrorException, InvalidParameterException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(OptInPhoneNumberResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (OptInPhoneNumberResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("OptInPhoneNumber").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)optInPhoneNumberRequest).withMarshaller((Marshaller)new OptInPhoneNumberRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public PublishResponse publish(PublishRequest publishRequest) throws InvalidParameterException, InvalidParameterValueException, InternalErrorException, NotFoundException, EndpointDisabledException, PlatformApplicationDisabledException, AuthorizationErrorException, KmsDisabledException, KmsInvalidStateException, KmsNotFoundException, KmsOptInRequiredException, KmsThrottlingException, KmsAccessDeniedException, InvalidSecurityException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PublishResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (PublishResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("Publish").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)publishRequest).withMarshaller((Marshaller)new PublishRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RemovePermissionResponse removePermission(RemovePermissionRequest removePermissionRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, NotFoundException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RemovePermissionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (RemovePermissionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemovePermission").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removePermissionRequest).withMarshaller((Marshaller)new RemovePermissionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SetEndpointAttributesResponse setEndpointAttributes(SetEndpointAttributesRequest setEndpointAttributesRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, NotFoundException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetEndpointAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (SetEndpointAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetEndpointAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setEndpointAttributesRequest).withMarshaller((Marshaller)new SetEndpointAttributesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SetPlatformApplicationAttributesResponse setPlatformApplicationAttributes(SetPlatformApplicationAttributesRequest setPlatformApplicationAttributesRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, NotFoundException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetPlatformApplicationAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (SetPlatformApplicationAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetPlatformApplicationAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setPlatformApplicationAttributesRequest).withMarshaller((Marshaller)new SetPlatformApplicationAttributesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SetSmsAttributesResponse setSMSAttributes(SetSmsAttributesRequest setSmsAttributesRequest) throws InvalidParameterException, ThrottledException, InternalErrorException, AuthorizationErrorException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetSmsAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (SetSmsAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetSMSAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setSmsAttributesRequest).withMarshaller((Marshaller)new SetSmsAttributesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SetSubscriptionAttributesResponse setSubscriptionAttributes(SetSubscriptionAttributesRequest setSubscriptionAttributesRequest) throws InvalidParameterException, FilterPolicyLimitExceededException, InternalErrorException, NotFoundException, AuthorizationErrorException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetSubscriptionAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (SetSubscriptionAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetSubscriptionAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setSubscriptionAttributesRequest).withMarshaller((Marshaller)new SetSubscriptionAttributesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SetTopicAttributesResponse setTopicAttributes(SetTopicAttributesRequest setTopicAttributesRequest) throws InvalidParameterException, InternalErrorException, NotFoundException, AuthorizationErrorException, InvalidSecurityException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetTopicAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (SetTopicAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetTopicAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setTopicAttributesRequest).withMarshaller((Marshaller)new SetTopicAttributesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SubscribeResponse subscribe(SubscribeRequest subscribeRequest) throws SubscriptionLimitExceededException, FilterPolicyLimitExceededException, InvalidParameterException, InternalErrorException, NotFoundException, AuthorizationErrorException, InvalidSecurityException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SubscribeResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (SubscribeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("Subscribe").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)subscribeRequest).withMarshaller((Marshaller)new SubscribeRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException, TagLimitExceededException, StaleTagException, TagPolicyException, InvalidParameterException, AuthorizationErrorException, ConcurrentAccessException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(TagResourceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMarshaller((Marshaller)new TagResourceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UnsubscribeResponse unsubscribe(UnsubscribeRequest unsubscribeRequest) throws InvalidParameterException, InternalErrorException, AuthorizationErrorException, NotFoundException, InvalidSecurityException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UnsubscribeResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (UnsubscribeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("Unsubscribe").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)unsubscribeRequest).withMarshaller((Marshaller)new UnsubscribeRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException, TagLimitExceededException, StaleTagException, TagPolicyException, InvalidParameterException, AuthorizationErrorException, ConcurrentAccessException, AwsServiceException, SdkClientException, SnsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UntagResourceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMarshaller((Marshaller)new UntagResourceRequestMarshaller(this.protocolFactory)));
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("SubscriptionLimitExceeded").exceptionBuilderSupplier(SubscriptionLimitExceededException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("KMSThrottling").exceptionBuilderSupplier(KmsThrottlingException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParameter").exceptionBuilderSupplier(InvalidParameterException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ParameterValueInvalid").exceptionBuilderSupplier(InvalidParameterValueException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EndpointDisabled").exceptionBuilderSupplier(EndpointDisabledException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FilterPolicyLimitExceeded").exceptionBuilderSupplier(FilterPolicyLimitExceededException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFound").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("KMSInvalidState").exceptionBuilderSupplier(KmsInvalidStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("KMSNotFound").exceptionBuilderSupplier(KmsNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("KMSOptInRequired").exceptionBuilderSupplier(KmsOptInRequiredException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("StaleTag").exceptionBuilderSupplier(StaleTagException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("KMSAccessDenied").exceptionBuilderSupplier(KmsAccessDeniedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotFound").exceptionBuilderSupplier(NotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("KMSDisabled").exceptionBuilderSupplier(KmsDisabledException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TopicLimitExceeded").exceptionBuilderSupplier(TopicLimitExceededException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TagPolicy").exceptionBuilderSupplier(TagPolicyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TagLimitExceeded").exceptionBuilderSupplier(TagLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("Throttled").exceptionBuilderSupplier(ThrottledException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PlatformApplicationDisabled").exceptionBuilderSupplier(PlatformApplicationDisabledException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalError").exceptionBuilderSupplier(InternalErrorException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AuthorizationError").exceptionBuilderSupplier(AuthorizationErrorException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConcurrentAccess").exceptionBuilderSupplier(ConcurrentAccessException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSecurity").exceptionBuilderSupplier(InvalidSecurityException::builder).httpStatusCode(Integer.valueOf(403)).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(SnsException::builder).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends SnsRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.13.0").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((SnsRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

