/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sns.model.SnsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OptInPhoneNumberRequest
extends SnsRequest
implements ToCopyableBuilder<Builder, OptInPhoneNumberRequest> {
    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OptInPhoneNumberRequest.getter(OptInPhoneNumberRequest::phoneNumber)).setter(OptInPhoneNumberRequest.setter(Builder::phoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("phoneNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBER_FIELD));
    private final String phoneNumber;

    private OptInPhoneNumberRequest(BuilderImpl builder) {
        super(builder);
        this.phoneNumber = builder.phoneNumber;
    }

    public String phoneNumber() {
        return this.phoneNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumber());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptInPhoneNumberRequest)) {
            return false;
        }
        OptInPhoneNumberRequest other = (OptInPhoneNumberRequest)((Object)obj);
        return Objects.equals(this.phoneNumber(), other.phoneNumber());
    }

    public String toString() {
        return ToString.builder((String)"OptInPhoneNumberRequest").add("PhoneNumber", (Object)this.phoneNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "phoneNumber": {
                return Optional.ofNullable(clazz.cast(this.phoneNumber()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OptInPhoneNumberRequest, T> g) {
        return obj -> g.apply((OptInPhoneNumberRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SnsRequest.BuilderImpl
    implements Builder {
        private String phoneNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(OptInPhoneNumberRequest model) {
            super(model);
            this.phoneNumber(model.phoneNumber);
        }

        public final String getPhoneNumber() {
            return this.phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public OptInPhoneNumberRequest build() {
            return new OptInPhoneNumberRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SnsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, OptInPhoneNumberRequest> {
        public Builder phoneNumber(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

