/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.sns.SNSClient;
import software.amazon.awssdk.services.sns.model.ListTopicsRequest;
import software.amazon.awssdk.services.sns.model.ListTopicsResponse;
import software.amazon.awssdk.services.sns.model.Topic;

public class ListTopicsIterable
implements SdkIterable<ListTopicsResponse> {
    private final SNSClient client;
    private final ListTopicsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTopicsIterable(SNSClient client, ListTopicsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTopicsResponseFetcher();
    }

    public Iterator<ListTopicsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<Topic> topics() {
        Function<ListTopicsResponse, Iterator> getIterator = response -> {
            if (response != null && response.topics() != null) {
                return response.topics().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListTopicsIterable resume(ListTopicsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListTopicsIterable(this.client, (ListTopicsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListTopicsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListTopicsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListTopicsResponseFetcher
    implements SyncPageFetcher<ListTopicsResponse> {
        private ListTopicsResponseFetcher() {
        }

        public boolean hasNextPage(ListTopicsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListTopicsResponse nextPage(ListTopicsResponse previousPage) {
            if (previousPage == null) {
                return ListTopicsIterable.this.client.listTopics(ListTopicsIterable.this.firstRequest);
            }
            return ListTopicsIterable.this.client.listTopics((ListTopicsRequest)((Object)ListTopicsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

