/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.sns.SNSClient;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsRequest;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsResponse;
import software.amazon.awssdk.services.sns.model.Subscription;

public class ListSubscriptionsIterable
implements SdkIterable<ListSubscriptionsResponse> {
    private final SNSClient client;
    private final ListSubscriptionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSubscriptionsIterable(SNSClient client, ListSubscriptionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSubscriptionsResponseFetcher();
    }

    public Iterator<ListSubscriptionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<Subscription> subscriptions() {
        Function<ListSubscriptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.subscriptions() != null) {
                return response.subscriptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListSubscriptionsIterable resume(ListSubscriptionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListSubscriptionsIterable(this.client, (ListSubscriptionsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListSubscriptionsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListSubscriptionsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListSubscriptionsResponseFetcher
    implements SyncPageFetcher<ListSubscriptionsResponse> {
        private ListSubscriptionsResponseFetcher() {
        }

        public boolean hasNextPage(ListSubscriptionsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListSubscriptionsResponse nextPage(ListSubscriptionsResponse previousPage) {
            if (previousPage == null) {
                return ListSubscriptionsIterable.this.client.listSubscriptions(ListSubscriptionsIterable.this.firstRequest);
            }
            return ListSubscriptionsIterable.this.client.listSubscriptions((ListSubscriptionsRequest)((Object)ListSubscriptionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

