/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.sns.SNSClient;
import software.amazon.awssdk.services.sns.model.ListTopicsRequest;
import software.amazon.awssdk.services.sns.model.ListTopicsResponse;
import software.amazon.awssdk.services.sns.model.Topic;

public final class ListTopicsPaginator
implements SdkIterable<ListTopicsResponse> {
    private final SNSClient client;
    private final ListTopicsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListTopicsPaginator(SNSClient client, ListTopicsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTopicsResponseFetcher();
    }

    public Iterator<ListTopicsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Topic> topics() {
        Function<ListTopicsResponse, Iterator> getIterator = response -> response != null ? response.topics().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListTopicsResponseFetcher
    implements NextPageFetcher<ListTopicsResponse> {
        private ListTopicsResponseFetcher() {
        }

        public boolean hasNextPage(ListTopicsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListTopicsResponse nextPage(ListTopicsResponse previousPage) {
            if (previousPage == null) {
                return ListTopicsPaginator.this.client.listTopics(ListTopicsPaginator.this.firstRequest);
            }
            return ListTopicsPaginator.this.client.listTopics((ListTopicsRequest)((Object)ListTopicsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

