/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.sns.model.SubscribeRequest;

public class SubscribeRequestMarshaller
implements Marshaller<Request<SubscribeRequest>, SubscribeRequest> {
    public Request<SubscribeRequest> marshall(SubscribeRequest subscribeRequest) {
        if (subscribeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)subscribeRequest, "SNSClient");
        request.addParameter("Action", "Subscribe");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (subscribeRequest.topicArn() != null) {
            request.addParameter("TopicArn", StringUtils.fromString((String)subscribeRequest.topicArn()));
        }
        if (subscribeRequest.protocol() != null) {
            request.addParameter("Protocol", StringUtils.fromString((String)subscribeRequest.protocol()));
        }
        if (subscribeRequest.endpoint() != null) {
            request.addParameter("Endpoint", StringUtils.fromString((String)subscribeRequest.endpoint()));
        }
        return request;
    }
}

