/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.sns.model.DeleteTopicRequest;

public class DeleteTopicRequestMarshaller
implements Marshaller<Request<DeleteTopicRequest>, DeleteTopicRequest> {
    public Request<DeleteTopicRequest> marshall(DeleteTopicRequest deleteTopicRequest) {
        if (deleteTopicRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteTopicRequest, "SNSClient");
        request.addParameter("Action", "DeleteTopic");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteTopicRequest.topicArn() != null) {
            request.addParameter("TopicArn", StringUtils.fromString((String)deleteTopicRequest.topicArn()));
        }
        return request;
    }
}

