/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.sns.model.ListOfPlatformApplicationsCopier;
import software.amazon.awssdk.services.sns.model.PlatformApplication;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListPlatformApplicationsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListPlatformApplicationsResponse> {
    private final List<PlatformApplication> platformApplications;
    private final String nextToken;

    private ListPlatformApplicationsResponse(BuilderImpl builder) {
        this.platformApplications = builder.platformApplications;
        this.nextToken = builder.nextToken;
    }

    public List<PlatformApplication> platformApplications() {
        return this.platformApplications;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.platformApplications() == null ? 0 : this.platformApplications().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPlatformApplicationsResponse)) {
            return false;
        }
        ListPlatformApplicationsResponse other = (ListPlatformApplicationsResponse)((Object)obj);
        if (other.platformApplications() == null ^ this.platformApplications() == null) {
            return false;
        }
        if (other.platformApplications() != null && !other.platformApplications().equals(this.platformApplications())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.platformApplications() != null) {
            sb.append("PlatformApplications: ").append(this.platformApplications()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlatformApplications": {
                return Optional.of(clazz.cast(this.platformApplications()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<PlatformApplication> platformApplications;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPlatformApplicationsResponse model) {
            this.platformApplications(model.platformApplications);
            this.nextToken(model.nextToken);
        }

        public final Collection<PlatformApplication.Builder> getPlatformApplications() {
            return this.platformApplications != null ? (Collection)this.platformApplications.stream().map(PlatformApplication::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder platformApplications(Collection<PlatformApplication> platformApplications) {
            this.platformApplications = ListOfPlatformApplicationsCopier.copy(platformApplications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformApplications(PlatformApplication ... platformApplications) {
            this.platformApplications(Arrays.asList(platformApplications));
            return this;
        }

        public final void setPlatformApplications(Collection<PlatformApplication.BuilderImpl> platformApplications) {
            this.platformApplications = ListOfPlatformApplicationsCopier.copyFromBuilder(platformApplications);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListPlatformApplicationsResponse build() {
            return new ListPlatformApplicationsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListPlatformApplicationsResponse> {
        public Builder platformApplications(Collection<PlatformApplication> var1);

        public Builder platformApplications(PlatformApplication ... var1);

        public Builder nextToken(String var1);
    }
}

