/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.sns.model.MapStringToStringCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SetEndpointAttributesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, SetEndpointAttributesRequest> {
    private final String endpointArn;
    private final Map<String, String> attributes;

    private SetEndpointAttributesRequest(BuilderImpl builder) {
        this.endpointArn = builder.endpointArn;
        this.attributes = builder.attributes;
    }

    public String endpointArn() {
        return this.endpointArn;
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.endpointArn() == null ? 0 : this.endpointArn().hashCode());
        hashCode = 31 * hashCode + (this.attributes() == null ? 0 : this.attributes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetEndpointAttributesRequest)) {
            return false;
        }
        SetEndpointAttributesRequest other = (SetEndpointAttributesRequest)((Object)obj);
        if (other.endpointArn() == null ^ this.endpointArn() == null) {
            return false;
        }
        if (other.endpointArn() != null && !other.endpointArn().equals(this.endpointArn())) {
            return false;
        }
        if (other.attributes() == null ^ this.attributes() == null) {
            return false;
        }
        return other.attributes() == null || other.attributes().equals(this.attributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.endpointArn() != null) {
            sb.append("EndpointArn: ").append(this.endpointArn()).append(",");
        }
        if (this.attributes() != null) {
            sb.append("Attributes: ").append(this.attributes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String endpointArn;
        private Map<String, String> attributes;

        private BuilderImpl() {
        }

        private BuilderImpl(SetEndpointAttributesRequest model) {
            this.setEndpointArn(model.endpointArn);
            this.setAttributes(model.attributes);
        }

        public final String getEndpointArn() {
            return this.endpointArn;
        }

        @Override
        public final Builder endpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
            return this;
        }

        public final void setEndpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = MapStringToStringCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = MapStringToStringCopier.copy(attributes);
        }

        public SetEndpointAttributesRequest build() {
            return new SetEndpointAttributesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SetEndpointAttributesRequest> {
        public Builder endpointArn(String var1);

        public Builder attributes(Map<String, String> var1);
    }
}

