/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.sns.model.DeleteTopicRequest;

public class DeleteTopicRequestMarshaller
implements Marshaller<Request<DeleteTopicRequest>, DeleteTopicRequest> {
    public Request<DeleteTopicRequest> marshall(DeleteTopicRequest deleteTopicRequest) {
        if (deleteTopicRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteTopicRequest, "SnsClient");
        request.addParameter("Action", "DeleteTopic");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteTopicRequest.topicArn() != null) {
            request.addParameter("TopicArn", StringConversion.fromString((String)deleteTopicRequest.topicArn()));
        }
        return request;
    }
}

