/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.sns.model.SnsResponse;
import software.amazon.awssdk.services.sns.model.Subscription;
import software.amazon.awssdk.services.sns.model.SubscriptionsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSubscriptionsByTopicResponse
extends SnsResponse
implements ToCopyableBuilder<Builder, ListSubscriptionsByTopicResponse> {
    private final List<Subscription> subscriptions;
    private final String nextToken;

    private ListSubscriptionsByTopicResponse(BuilderImpl builder) {
        super(builder);
        this.subscriptions = builder.subscriptions;
        this.nextToken = builder.nextToken;
    }

    public List<Subscription> subscriptions() {
        return this.subscriptions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSubscriptionsByTopicResponse)) {
            return false;
        }
        ListSubscriptionsByTopicResponse other = (ListSubscriptionsByTopicResponse)((Object)obj);
        return Objects.equals(this.subscriptions(), other.subscriptions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListSubscriptionsByTopicResponse").add("Subscriptions", this.subscriptions()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Subscriptions": {
                return Optional.ofNullable(clazz.cast(this.subscriptions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SnsResponse.BuilderImpl
    implements Builder {
        private List<Subscription> subscriptions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSubscriptionsByTopicResponse model) {
            super(model);
            this.subscriptions(model.subscriptions);
            this.nextToken(model.nextToken);
        }

        public final Collection<Subscription.Builder> getSubscriptions() {
            return this.subscriptions != null ? (Collection)this.subscriptions.stream().map(Subscription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder subscriptions(Collection<Subscription> subscriptions) {
            this.subscriptions = SubscriptionsListCopier.copy(subscriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptions(Subscription ... subscriptions) {
            this.subscriptions(Arrays.asList(subscriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptions(Consumer<Subscription.Builder> ... subscriptions) {
            this.subscriptions(Stream.of(subscriptions).map(c -> (Subscription)((Subscription.Builder)Subscription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSubscriptions(Collection<Subscription.BuilderImpl> subscriptions) {
            this.subscriptions = SubscriptionsListCopier.copyFromBuilder(subscriptions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSubscriptionsByTopicResponse build() {
            return new ListSubscriptionsByTopicResponse(this);
        }
    }

    public static interface Builder
    extends SnsResponse.Builder,
    CopyableBuilder<Builder, ListSubscriptionsByTopicResponse> {
        public Builder subscriptions(Collection<Subscription> var1);

        public Builder subscriptions(Subscription ... var1);

        public Builder subscriptions(Consumer<Subscription.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

