/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.sns.model.OptInPhoneNumberRequest;
import software.amazon.awssdk.util.StringUtils;

public class OptInPhoneNumberRequestMarshaller
implements Marshaller<Request<OptInPhoneNumberRequest>, OptInPhoneNumberRequest> {
    public Request<OptInPhoneNumberRequest> marshall(OptInPhoneNumberRequest optInPhoneNumberRequest) {
        if (optInPhoneNumberRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)optInPhoneNumberRequest, "SNSClient");
        request.addParameter("Action", "OptInPhoneNumber");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (optInPhoneNumberRequest.phoneNumber() != null) {
            request.addParameter("phoneNumber", StringUtils.fromString((String)optInPhoneNumberRequest.phoneNumber()));
        }
        return request;
    }
}

