/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.sns.model.GetSMSAttributesRequest;
import software.amazon.awssdk.util.StringUtils;

public class GetSMSAttributesRequestMarshaller
implements Marshaller<Request<GetSMSAttributesRequest>, GetSMSAttributesRequest> {
    public Request<GetSMSAttributesRequest> marshall(GetSMSAttributesRequest getSMSAttributesRequest) {
        if (getSMSAttributesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getSMSAttributesRequest, "SNSClient");
        request.addParameter("Action", "GetSMSAttributes");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList attributesList = (SdkInternalList)getSMSAttributesRequest.attributes();
        if (!attributesList.isEmpty() || !attributesList.isAutoConstruct()) {
            int attributesListIndex = 1;
            for (String attributesListValue : attributesList) {
                if (attributesListValue != null) {
                    request.addParameter("attributes.member." + attributesListIndex, StringUtils.fromString((String)attributesListValue));
                }
                ++attributesListIndex;
            }
        }
        return request;
    }
}

