/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Map;
import software.amazon.awssdk.runtime.SdkInternalMap;
import software.amazon.awssdk.services.sns.model.MapStringToStringCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PlatformApplication
implements ToCopyableBuilder<Builder, PlatformApplication> {
    private final String platformApplicationArn;
    private final Map<String, String> attributes;

    private PlatformApplication(BuilderImpl builder) {
        this.platformApplicationArn = builder.platformApplicationArn;
        this.attributes = builder.attributes;
    }

    public String platformApplicationArn() {
        return this.platformApplicationArn;
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.platformApplicationArn() == null ? 0 : this.platformApplicationArn().hashCode());
        hashCode = 31 * hashCode + (this.attributes() == null ? 0 : this.attributes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlatformApplication)) {
            return false;
        }
        PlatformApplication other = (PlatformApplication)obj;
        if (other.platformApplicationArn() == null ^ this.platformApplicationArn() == null) {
            return false;
        }
        if (other.platformApplicationArn() != null && !other.platformApplicationArn().equals(this.platformApplicationArn())) {
            return false;
        }
        if (other.attributes() == null ^ this.attributes() == null) {
            return false;
        }
        return other.attributes() == null || other.attributes().equals(this.attributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.platformApplicationArn() != null) {
            sb.append("PlatformApplicationArn: ").append(this.platformApplicationArn()).append(",");
        }
        if (this.attributes() != null) {
            sb.append("Attributes: ").append(this.attributes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String platformApplicationArn;
        private Map<String, String> attributes = new SdkInternalMap();

        private BuilderImpl() {
        }

        private BuilderImpl(PlatformApplication model) {
            this.setPlatformApplicationArn(model.platformApplicationArn);
            this.setAttributes(model.attributes);
        }

        public final String getPlatformApplicationArn() {
            return this.platformApplicationArn;
        }

        @Override
        public final Builder platformApplicationArn(String platformApplicationArn) {
            this.platformApplicationArn = platformApplicationArn;
            return this;
        }

        public final void setPlatformApplicationArn(String platformApplicationArn) {
            this.platformApplicationArn = platformApplicationArn;
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = MapStringToStringCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = MapStringToStringCopier.copy(attributes);
        }

        public PlatformApplication build() {
            return new PlatformApplication(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PlatformApplication> {
        public Builder platformApplicationArn(String var1);

        public Builder attributes(Map<String, String> var1);
    }
}

