/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.sns.model.Endpoint;
import software.amazon.awssdk.services.sns.model.ListOfEndpointsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListEndpointsByPlatformApplicationResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListEndpointsByPlatformApplicationResponse> {
    private final List<Endpoint> endpoints;
    private final String nextToken;

    private ListEndpointsByPlatformApplicationResponse(BuilderImpl builder) {
        this.endpoints = builder.endpoints;
        this.nextToken = builder.nextToken;
    }

    public List<Endpoint> endpoints() {
        return this.endpoints;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.endpoints() == null ? 0 : this.endpoints().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEndpointsByPlatformApplicationResponse)) {
            return false;
        }
        ListEndpointsByPlatformApplicationResponse other = (ListEndpointsByPlatformApplicationResponse)((Object)obj);
        if (other.endpoints() == null ^ this.endpoints() == null) {
            return false;
        }
        if (other.endpoints() != null && !other.endpoints().equals(this.endpoints())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.endpoints() != null) {
            sb.append("Endpoints: ").append(this.endpoints()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Endpoint> endpoints = new SdkInternalList();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEndpointsByPlatformApplicationResponse model) {
            this.setEndpoints(model.endpoints);
            this.setNextToken(model.nextToken);
        }

        public final Collection<Endpoint> getEndpoints() {
            return this.endpoints;
        }

        @Override
        public final Builder endpoints(Collection<Endpoint> endpoints) {
            this.endpoints = ListOfEndpointsCopier.copy(endpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(Endpoint ... endpoints) {
            if (this.endpoints == null) {
                this.endpoints = new SdkInternalList(endpoints.length);
            }
            for (Endpoint e : endpoints) {
                this.endpoints.add(e);
            }
            return this;
        }

        public final void setEndpoints(Collection<Endpoint> endpoints) {
            this.endpoints = ListOfEndpointsCopier.copy(endpoints);
        }

        @SafeVarargs
        public final void setEndpoints(Endpoint ... endpoints) {
            if (this.endpoints == null) {
                this.endpoints = new SdkInternalList(endpoints.length);
            }
            for (Endpoint e : endpoints) {
                this.endpoints.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListEndpointsByPlatformApplicationResponse build() {
            return new ListEndpointsByPlatformApplicationResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListEndpointsByPlatformApplicationResponse> {
        public Builder endpoints(Collection<Endpoint> var1);

        public Builder endpoints(Endpoint ... var1);

        public Builder nextToken(String var1);
    }
}

