/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowdevicemanagement.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.snowdevicemanagement.model.SnowDeviceManagementRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeExecutionRequest
extends SnowDeviceManagementRequest
implements ToCopyableBuilder<Builder, DescribeExecutionRequest> {
    private static final SdkField<String> MANAGED_DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("managedDeviceId").getter(DescribeExecutionRequest.getter(DescribeExecutionRequest::managedDeviceId)).setter(DescribeExecutionRequest.setter(Builder::managedDeviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("managedDeviceId").build()}).build();
    private static final SdkField<String> TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskId").getter(DescribeExecutionRequest.getter(DescribeExecutionRequest::taskId)).setter(DescribeExecutionRequest.setter(Builder::taskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("taskId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANAGED_DEVICE_ID_FIELD, TASK_ID_FIELD));
    private final String managedDeviceId;
    private final String taskId;

    private DescribeExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.managedDeviceId = builder.managedDeviceId;
        this.taskId = builder.taskId;
    }

    public final String managedDeviceId() {
        return this.managedDeviceId;
    }

    public final String taskId() {
        return this.taskId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.managedDeviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExecutionRequest)) {
            return false;
        }
        DescribeExecutionRequest other = (DescribeExecutionRequest)((Object)obj);
        return Objects.equals(this.managedDeviceId(), other.managedDeviceId()) && Objects.equals(this.taskId(), other.taskId());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeExecutionRequest").add("ManagedDeviceId", (Object)this.managedDeviceId()).add("TaskId", (Object)this.taskId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "managedDeviceId": {
                return Optional.ofNullable(clazz.cast(this.managedDeviceId()));
            }
            case "taskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeExecutionRequest, T> g) {
        return obj -> g.apply((DescribeExecutionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SnowDeviceManagementRequest.BuilderImpl
    implements Builder {
        private String managedDeviceId;
        private String taskId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExecutionRequest model) {
            super(model);
            this.managedDeviceId(model.managedDeviceId);
            this.taskId(model.taskId);
        }

        public final String getManagedDeviceId() {
            return this.managedDeviceId;
        }

        public final void setManagedDeviceId(String managedDeviceId) {
            this.managedDeviceId = managedDeviceId;
        }

        @Override
        public final Builder managedDeviceId(String managedDeviceId) {
            this.managedDeviceId = managedDeviceId;
            return this;
        }

        public final String getTaskId() {
            return this.taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeExecutionRequest build() {
            return new DescribeExecutionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SnowDeviceManagementRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeExecutionRequest> {
        public Builder managedDeviceId(String var1);

        public Builder taskId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

