/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.snowball.model.DataTransfer;
import software.amazon.awssdk.services.snowball.model.JobLogs;
import software.amazon.awssdk.services.snowball.model.JobResource;
import software.amazon.awssdk.services.snowball.model.JobState;
import software.amazon.awssdk.services.snowball.model.JobType;
import software.amazon.awssdk.services.snowball.model.Notification;
import software.amazon.awssdk.services.snowball.model.ShippingDetails;
import software.amazon.awssdk.services.snowball.model.SnowballCapacity;
import software.amazon.awssdk.services.snowball.model.SnowballType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobMetadata> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobMetadata.getter(JobMetadata::jobId)).setter(JobMetadata.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()}).build();
    private static final SdkField<String> JOB_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobMetadata.getter(JobMetadata::jobStateAsString)).setter(JobMetadata.setter(Builder::jobState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobState").build()}).build();
    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobMetadata.getter(JobMetadata::jobTypeAsString)).setter(JobMetadata.setter(Builder::jobType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobType").build()}).build();
    private static final SdkField<String> SNOWBALL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobMetadata.getter(JobMetadata::snowballTypeAsString)).setter(JobMetadata.setter(Builder::snowballType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnowballType").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(JobMetadata.getter(JobMetadata::creationDate)).setter(JobMetadata.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<JobResource> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(JobMetadata.getter(JobMetadata::resources)).setter(JobMetadata.setter(Builder::resources)).constructor(JobResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resources").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobMetadata.getter(JobMetadata::description)).setter(JobMetadata.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobMetadata.getter(JobMetadata::kmsKeyARN)).setter(JobMetadata.setter(Builder::kmsKeyARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyARN").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobMetadata.getter(JobMetadata::roleARN)).setter(JobMetadata.setter(Builder::roleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()}).build();
    private static final SdkField<String> ADDRESS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobMetadata.getter(JobMetadata::addressId)).setter(JobMetadata.setter(Builder::addressId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressId").build()}).build();
    private static final SdkField<ShippingDetails> SHIPPING_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(JobMetadata.getter(JobMetadata::shippingDetails)).setter(JobMetadata.setter(Builder::shippingDetails)).constructor(ShippingDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShippingDetails").build()}).build();
    private static final SdkField<String> SNOWBALL_CAPACITY_PREFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobMetadata.getter(JobMetadata::snowballCapacityPreferenceAsString)).setter(JobMetadata.setter(Builder::snowballCapacityPreference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnowballCapacityPreference").build()}).build();
    private static final SdkField<Notification> NOTIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(JobMetadata.getter(JobMetadata::notification)).setter(JobMetadata.setter(Builder::notification)).constructor(Notification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notification").build()}).build();
    private static final SdkField<DataTransfer> DATA_TRANSFER_PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(JobMetadata.getter(JobMetadata::dataTransferProgress)).setter(JobMetadata.setter(Builder::dataTransferProgress)).constructor(DataTransfer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTransferProgress").build()}).build();
    private static final SdkField<JobLogs> JOB_LOG_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(JobMetadata.getter(JobMetadata::jobLogInfo)).setter(JobMetadata.setter(Builder::jobLogInfo)).constructor(JobLogs::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobLogInfo").build()}).build();
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobMetadata.getter(JobMetadata::clusterId)).setter(JobMetadata.setter(Builder::clusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()}).build();
    private static final SdkField<String> FORWARDING_ADDRESS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobMetadata.getter(JobMetadata::forwardingAddressId)).setter(JobMetadata.setter(Builder::forwardingAddressId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForwardingAddressId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, JOB_STATE_FIELD, JOB_TYPE_FIELD, SNOWBALL_TYPE_FIELD, CREATION_DATE_FIELD, RESOURCES_FIELD, DESCRIPTION_FIELD, KMS_KEY_ARN_FIELD, ROLE_ARN_FIELD, ADDRESS_ID_FIELD, SHIPPING_DETAILS_FIELD, SNOWBALL_CAPACITY_PREFERENCE_FIELD, NOTIFICATION_FIELD, DATA_TRANSFER_PROGRESS_FIELD, JOB_LOG_INFO_FIELD, CLUSTER_ID_FIELD, FORWARDING_ADDRESS_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String jobId;
    private final String jobState;
    private final String jobType;
    private final String snowballType;
    private final Instant creationDate;
    private final JobResource resources;
    private final String description;
    private final String kmsKeyARN;
    private final String roleARN;
    private final String addressId;
    private final ShippingDetails shippingDetails;
    private final String snowballCapacityPreference;
    private final Notification notification;
    private final DataTransfer dataTransferProgress;
    private final JobLogs jobLogInfo;
    private final String clusterId;
    private final String forwardingAddressId;

    private JobMetadata(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.jobState = builder.jobState;
        this.jobType = builder.jobType;
        this.snowballType = builder.snowballType;
        this.creationDate = builder.creationDate;
        this.resources = builder.resources;
        this.description = builder.description;
        this.kmsKeyARN = builder.kmsKeyARN;
        this.roleARN = builder.roleARN;
        this.addressId = builder.addressId;
        this.shippingDetails = builder.shippingDetails;
        this.snowballCapacityPreference = builder.snowballCapacityPreference;
        this.notification = builder.notification;
        this.dataTransferProgress = builder.dataTransferProgress;
        this.jobLogInfo = builder.jobLogInfo;
        this.clusterId = builder.clusterId;
        this.forwardingAddressId = builder.forwardingAddressId;
    }

    public String jobId() {
        return this.jobId;
    }

    public JobState jobState() {
        return JobState.fromValue(this.jobState);
    }

    public String jobStateAsString() {
        return this.jobState;
    }

    public JobType jobType() {
        return JobType.fromValue(this.jobType);
    }

    public String jobTypeAsString() {
        return this.jobType;
    }

    public SnowballType snowballType() {
        return SnowballType.fromValue(this.snowballType);
    }

    public String snowballTypeAsString() {
        return this.snowballType;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public JobResource resources() {
        return this.resources;
    }

    public String description() {
        return this.description;
    }

    public String kmsKeyARN() {
        return this.kmsKeyARN;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public String addressId() {
        return this.addressId;
    }

    public ShippingDetails shippingDetails() {
        return this.shippingDetails;
    }

    public SnowballCapacity snowballCapacityPreference() {
        return SnowballCapacity.fromValue(this.snowballCapacityPreference);
    }

    public String snowballCapacityPreferenceAsString() {
        return this.snowballCapacityPreference;
    }

    public Notification notification() {
        return this.notification;
    }

    public DataTransfer dataTransferProgress() {
        return this.dataTransferProgress;
    }

    public JobLogs jobLogInfo() {
        return this.jobLogInfo;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public String forwardingAddressId() {
        return this.forwardingAddressId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.snowballTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.resources());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressId());
        hashCode = 31 * hashCode + Objects.hashCode(this.shippingDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.snowballCapacityPreferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.notification());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTransferProgress());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobLogInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.forwardingAddressId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobMetadata)) {
            return false;
        }
        JobMetadata other = (JobMetadata)obj;
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.jobStateAsString(), other.jobStateAsString()) && Objects.equals(this.jobTypeAsString(), other.jobTypeAsString()) && Objects.equals(this.snowballTypeAsString(), other.snowballTypeAsString()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.resources(), other.resources()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.kmsKeyARN(), other.kmsKeyARN()) && Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.addressId(), other.addressId()) && Objects.equals(this.shippingDetails(), other.shippingDetails()) && Objects.equals(this.snowballCapacityPreferenceAsString(), other.snowballCapacityPreferenceAsString()) && Objects.equals(this.notification(), other.notification()) && Objects.equals(this.dataTransferProgress(), other.dataTransferProgress()) && Objects.equals(this.jobLogInfo(), other.jobLogInfo()) && Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.forwardingAddressId(), other.forwardingAddressId());
    }

    public String toString() {
        return ToString.builder((String)"JobMetadata").add("JobId", (Object)this.jobId()).add("JobState", (Object)this.jobStateAsString()).add("JobType", (Object)this.jobTypeAsString()).add("SnowballType", (Object)this.snowballTypeAsString()).add("CreationDate", (Object)this.creationDate()).add("Resources", (Object)this.resources()).add("Description", (Object)this.description()).add("KmsKeyARN", (Object)this.kmsKeyARN()).add("RoleARN", (Object)this.roleARN()).add("AddressId", (Object)this.addressId()).add("ShippingDetails", (Object)this.shippingDetails()).add("SnowballCapacityPreference", (Object)this.snowballCapacityPreferenceAsString()).add("Notification", (Object)this.notification()).add("DataTransferProgress", (Object)this.dataTransferProgress()).add("JobLogInfo", (Object)this.jobLogInfo()).add("ClusterId", (Object)this.clusterId()).add("ForwardingAddressId", (Object)this.forwardingAddressId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "JobState": {
                return Optional.ofNullable(clazz.cast(this.jobStateAsString()));
            }
            case "JobType": {
                return Optional.ofNullable(clazz.cast(this.jobTypeAsString()));
            }
            case "SnowballType": {
                return Optional.ofNullable(clazz.cast(this.snowballTypeAsString()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "Resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "KmsKeyARN": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyARN()));
            }
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "AddressId": {
                return Optional.ofNullable(clazz.cast(this.addressId()));
            }
            case "ShippingDetails": {
                return Optional.ofNullable(clazz.cast(this.shippingDetails()));
            }
            case "SnowballCapacityPreference": {
                return Optional.ofNullable(clazz.cast(this.snowballCapacityPreferenceAsString()));
            }
            case "Notification": {
                return Optional.ofNullable(clazz.cast(this.notification()));
            }
            case "DataTransferProgress": {
                return Optional.ofNullable(clazz.cast(this.dataTransferProgress()));
            }
            case "JobLogInfo": {
                return Optional.ofNullable(clazz.cast(this.jobLogInfo()));
            }
            case "ClusterId": {
                return Optional.ofNullable(clazz.cast(this.clusterId()));
            }
            case "ForwardingAddressId": {
                return Optional.ofNullable(clazz.cast(this.forwardingAddressId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobMetadata, T> g) {
        return obj -> g.apply((JobMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobId;
        private String jobState;
        private String jobType;
        private String snowballType;
        private Instant creationDate;
        private JobResource resources;
        private String description;
        private String kmsKeyARN;
        private String roleARN;
        private String addressId;
        private ShippingDetails shippingDetails;
        private String snowballCapacityPreference;
        private Notification notification;
        private DataTransfer dataTransferProgress;
        private JobLogs jobLogInfo;
        private String clusterId;
        private String forwardingAddressId;

        private BuilderImpl() {
        }

        private BuilderImpl(JobMetadata model) {
            this.jobId(model.jobId);
            this.jobState(model.jobState);
            this.jobType(model.jobType);
            this.snowballType(model.snowballType);
            this.creationDate(model.creationDate);
            this.resources(model.resources);
            this.description(model.description);
            this.kmsKeyARN(model.kmsKeyARN);
            this.roleARN(model.roleARN);
            this.addressId(model.addressId);
            this.shippingDetails(model.shippingDetails);
            this.snowballCapacityPreference(model.snowballCapacityPreference);
            this.notification(model.notification);
            this.dataTransferProgress(model.dataTransferProgress);
            this.jobLogInfo(model.jobLogInfo);
            this.clusterId(model.clusterId);
            this.forwardingAddressId(model.forwardingAddressId);
        }

        public final String getJobId() {
            return this.jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getJobStateAsString() {
            return this.jobState;
        }

        @Override
        public final Builder jobState(String jobState) {
            this.jobState = jobState;
            return this;
        }

        @Override
        public final Builder jobState(JobState jobState) {
            this.jobState(jobState.toString());
            return this;
        }

        public final void setJobState(String jobState) {
            this.jobState = jobState;
        }

        public final String getJobTypeAsString() {
            return this.jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType.toString());
            return this;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        public final String getSnowballTypeAsString() {
            return this.snowballType;
        }

        @Override
        public final Builder snowballType(String snowballType) {
            this.snowballType = snowballType;
            return this;
        }

        @Override
        public final Builder snowballType(SnowballType snowballType) {
            this.snowballType(snowballType.toString());
            return this;
        }

        public final void setSnowballType(String snowballType) {
            this.snowballType = snowballType;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final JobResource.Builder getResources() {
            return this.resources != null ? this.resources.toBuilder() : null;
        }

        @Override
        public final Builder resources(JobResource resources) {
            this.resources = resources;
            return this;
        }

        public final void setResources(JobResource.BuilderImpl resources) {
            this.resources = resources != null ? resources.build() : null;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getKmsKeyARN() {
            return this.kmsKeyARN;
        }

        @Override
        public final Builder kmsKeyARN(String kmsKeyARN) {
            this.kmsKeyARN = kmsKeyARN;
            return this;
        }

        public final void setKmsKeyARN(String kmsKeyARN) {
            this.kmsKeyARN = kmsKeyARN;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getAddressId() {
            return this.addressId;
        }

        @Override
        public final Builder addressId(String addressId) {
            this.addressId = addressId;
            return this;
        }

        public final void setAddressId(String addressId) {
            this.addressId = addressId;
        }

        public final ShippingDetails.Builder getShippingDetails() {
            return this.shippingDetails != null ? this.shippingDetails.toBuilder() : null;
        }

        @Override
        public final Builder shippingDetails(ShippingDetails shippingDetails) {
            this.shippingDetails = shippingDetails;
            return this;
        }

        public final void setShippingDetails(ShippingDetails.BuilderImpl shippingDetails) {
            this.shippingDetails = shippingDetails != null ? shippingDetails.build() : null;
        }

        public final String getSnowballCapacityPreferenceAsString() {
            return this.snowballCapacityPreference;
        }

        @Override
        public final Builder snowballCapacityPreference(String snowballCapacityPreference) {
            this.snowballCapacityPreference = snowballCapacityPreference;
            return this;
        }

        @Override
        public final Builder snowballCapacityPreference(SnowballCapacity snowballCapacityPreference) {
            this.snowballCapacityPreference(snowballCapacityPreference.toString());
            return this;
        }

        public final void setSnowballCapacityPreference(String snowballCapacityPreference) {
            this.snowballCapacityPreference = snowballCapacityPreference;
        }

        public final Notification.Builder getNotification() {
            return this.notification != null ? this.notification.toBuilder() : null;
        }

        @Override
        public final Builder notification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public final void setNotification(Notification.BuilderImpl notification) {
            this.notification = notification != null ? notification.build() : null;
        }

        public final DataTransfer.Builder getDataTransferProgress() {
            return this.dataTransferProgress != null ? this.dataTransferProgress.toBuilder() : null;
        }

        @Override
        public final Builder dataTransferProgress(DataTransfer dataTransferProgress) {
            this.dataTransferProgress = dataTransferProgress;
            return this;
        }

        public final void setDataTransferProgress(DataTransfer.BuilderImpl dataTransferProgress) {
            this.dataTransferProgress = dataTransferProgress != null ? dataTransferProgress.build() : null;
        }

        public final JobLogs.Builder getJobLogInfo() {
            return this.jobLogInfo != null ? this.jobLogInfo.toBuilder() : null;
        }

        @Override
        public final Builder jobLogInfo(JobLogs jobLogInfo) {
            this.jobLogInfo = jobLogInfo;
            return this;
        }

        public final void setJobLogInfo(JobLogs.BuilderImpl jobLogInfo) {
            this.jobLogInfo = jobLogInfo != null ? jobLogInfo.build() : null;
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final String getForwardingAddressId() {
            return this.forwardingAddressId;
        }

        @Override
        public final Builder forwardingAddressId(String forwardingAddressId) {
            this.forwardingAddressId = forwardingAddressId;
            return this;
        }

        public final void setForwardingAddressId(String forwardingAddressId) {
            this.forwardingAddressId = forwardingAddressId;
        }

        public JobMetadata build() {
            return new JobMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobMetadata> {
        public Builder jobId(String var1);

        public Builder jobState(String var1);

        public Builder jobState(JobState var1);

        public Builder jobType(String var1);

        public Builder jobType(JobType var1);

        public Builder snowballType(String var1);

        public Builder snowballType(SnowballType var1);

        public Builder creationDate(Instant var1);

        public Builder resources(JobResource var1);

        default public Builder resources(Consumer<JobResource.Builder> resources) {
            return this.resources((JobResource)((JobResource.Builder)JobResource.builder().applyMutation(resources)).build());
        }

        public Builder description(String var1);

        public Builder kmsKeyARN(String var1);

        public Builder roleARN(String var1);

        public Builder addressId(String var1);

        public Builder shippingDetails(ShippingDetails var1);

        default public Builder shippingDetails(Consumer<ShippingDetails.Builder> shippingDetails) {
            return this.shippingDetails((ShippingDetails)((ShippingDetails.Builder)ShippingDetails.builder().applyMutation(shippingDetails)).build());
        }

        public Builder snowballCapacityPreference(String var1);

        public Builder snowballCapacityPreference(SnowballCapacity var1);

        public Builder notification(Notification var1);

        default public Builder notification(Consumer<Notification.Builder> notification) {
            return this.notification((Notification)((Notification.Builder)Notification.builder().applyMutation(notification)).build());
        }

        public Builder dataTransferProgress(DataTransfer var1);

        default public Builder dataTransferProgress(Consumer<DataTransfer.Builder> dataTransferProgress) {
            return this.dataTransferProgress((DataTransfer)((DataTransfer.Builder)DataTransfer.builder().applyMutation(dataTransferProgress)).build());
        }

        public Builder jobLogInfo(JobLogs var1);

        default public Builder jobLogInfo(Consumer<JobLogs.Builder> jobLogInfo) {
            return this.jobLogInfo((JobLogs)((JobLogs.Builder)JobLogs.builder().applyMutation(jobLogInfo)).build());
        }

        public Builder clusterId(String var1);

        public Builder forwardingAddressId(String var1);
    }
}

