/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateJobShipmentStateRequest extends SnowballRequest implements
        ToCopyableBuilder<UpdateJobShipmentStateRequest.Builder, UpdateJobShipmentStateRequest> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("JobId")
            .getter(getter(UpdateJobShipmentStateRequest::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()).build();

    private static final SdkField<String> SHIPMENT_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShipmentState").getter(getter(UpdateJobShipmentStateRequest::shipmentStateAsString))
            .setter(setter(Builder::shipmentState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShipmentState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD,
            SHIPMENT_STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String jobId;

    private final String shipmentState;

    private UpdateJobShipmentStateRequest(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.shipmentState = builder.shipmentState;
    }

    /**
     * <p>
     * The job ID of the job whose shipment date you want to update, for example
     * <code>JID123e4567-e89b-12d3-a456-426655440000</code>.
     * </p>
     * 
     * @return The job ID of the job whose shipment date you want to update, for example
     *         <code>JID123e4567-e89b-12d3-a456-426655440000</code>.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The state of a device when it is being shipped.
     * </p>
     * <p>
     * Set to <code>RECEIVED</code> when the device arrives at your location.
     * </p>
     * <p>
     * Set to <code>RETURNED</code> when you have returned the device to Amazon Web Services.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shipmentState}
     * will return {@link ShipmentState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #shipmentStateAsString}.
     * </p>
     * 
     * @return The state of a device when it is being shipped. </p>
     *         <p>
     *         Set to <code>RECEIVED</code> when the device arrives at your location.
     *         </p>
     *         <p>
     *         Set to <code>RETURNED</code> when you have returned the device to Amazon Web Services.
     * @see ShipmentState
     */
    public final ShipmentState shipmentState() {
        return ShipmentState.fromValue(shipmentState);
    }

    /**
     * <p>
     * The state of a device when it is being shipped.
     * </p>
     * <p>
     * Set to <code>RECEIVED</code> when the device arrives at your location.
     * </p>
     * <p>
     * Set to <code>RETURNED</code> when you have returned the device to Amazon Web Services.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shipmentState}
     * will return {@link ShipmentState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #shipmentStateAsString}.
     * </p>
     * 
     * @return The state of a device when it is being shipped. </p>
     *         <p>
     *         Set to <code>RECEIVED</code> when the device arrives at your location.
     *         </p>
     *         <p>
     *         Set to <code>RETURNED</code> when you have returned the device to Amazon Web Services.
     * @see ShipmentState
     */
    public final String shipmentStateAsString() {
        return shipmentState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(shipmentStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateJobShipmentStateRequest)) {
            return false;
        }
        UpdateJobShipmentStateRequest other = (UpdateJobShipmentStateRequest) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(shipmentStateAsString(), other.shipmentStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateJobShipmentStateRequest").add("JobId", jobId())
                .add("ShipmentState", shipmentStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "ShipmentState":
            return Optional.ofNullable(clazz.cast(shipmentStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("JobId", JOB_ID_FIELD);
        map.put("ShipmentState", SHIPMENT_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateJobShipmentStateRequest, T> g) {
        return obj -> g.apply((UpdateJobShipmentStateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SnowballRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateJobShipmentStateRequest> {
        /**
         * <p>
         * The job ID of the job whose shipment date you want to update, for example
         * <code>JID123e4567-e89b-12d3-a456-426655440000</code>.
         * </p>
         * 
         * @param jobId
         *        The job ID of the job whose shipment date you want to update, for example
         *        <code>JID123e4567-e89b-12d3-a456-426655440000</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The state of a device when it is being shipped.
         * </p>
         * <p>
         * Set to <code>RECEIVED</code> when the device arrives at your location.
         * </p>
         * <p>
         * Set to <code>RETURNED</code> when you have returned the device to Amazon Web Services.
         * </p>
         * 
         * @param shipmentState
         *        The state of a device when it is being shipped. </p>
         *        <p>
         *        Set to <code>RECEIVED</code> when the device arrives at your location.
         *        </p>
         *        <p>
         *        Set to <code>RETURNED</code> when you have returned the device to Amazon Web Services.
         * @see ShipmentState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShipmentState
         */
        Builder shipmentState(String shipmentState);

        /**
         * <p>
         * The state of a device when it is being shipped.
         * </p>
         * <p>
         * Set to <code>RECEIVED</code> when the device arrives at your location.
         * </p>
         * <p>
         * Set to <code>RETURNED</code> when you have returned the device to Amazon Web Services.
         * </p>
         * 
         * @param shipmentState
         *        The state of a device when it is being shipped. </p>
         *        <p>
         *        Set to <code>RECEIVED</code> when the device arrives at your location.
         *        </p>
         *        <p>
         *        Set to <code>RETURNED</code> when you have returned the device to Amazon Web Services.
         * @see ShipmentState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShipmentState
         */
        Builder shipmentState(ShipmentState shipmentState);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SnowballRequest.BuilderImpl implements Builder {
        private String jobId;

        private String shipmentState;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateJobShipmentStateRequest model) {
            super(model);
            jobId(model.jobId);
            shipmentState(model.shipmentState);
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getShipmentState() {
            return shipmentState;
        }

        public final void setShipmentState(String shipmentState) {
            this.shipmentState = shipmentState;
        }

        @Override
        public final Builder shipmentState(String shipmentState) {
            this.shipmentState = shipmentState;
            return this;
        }

        @Override
        public final Builder shipmentState(ShipmentState shipmentState) {
            this.shipmentState(shipmentState == null ? null : shipmentState.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateJobShipmentStateRequest build() {
            return new UpdateJobShipmentStateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
