/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains an array of Amazon Web Services resource objects. Each object represents an Amazon S3 bucket, an Lambda
 * function, or an Amazon Machine Image (AMI) based on Amazon EC2 that is associated with a particular job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobResource implements SdkPojo, Serializable, ToCopyableBuilder<JobResource.Builder, JobResource> {
    private static final SdkField<List<S3Resource>> S3_RESOURCES_FIELD = SdkField
            .<List<S3Resource>> builder(MarshallingType.LIST)
            .memberName("S3Resources")
            .getter(getter(JobResource::s3Resources))
            .setter(setter(Builder::s3Resources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Resources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<S3Resource> builder(MarshallingType.SDK_POJO)
                                            .constructor(S3Resource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<LambdaResource>> LAMBDA_RESOURCES_FIELD = SdkField
            .<List<LambdaResource>> builder(MarshallingType.LIST)
            .memberName("LambdaResources")
            .getter(getter(JobResource::lambdaResources))
            .setter(setter(Builder::lambdaResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LambdaResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(LambdaResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Ec2AmiResource>> EC2_AMI_RESOURCES_FIELD = SdkField
            .<List<Ec2AmiResource>> builder(MarshallingType.LIST)
            .memberName("Ec2AmiResources")
            .getter(getter(JobResource::ec2AmiResources))
            .setter(setter(Builder::ec2AmiResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2AmiResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Ec2AmiResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(Ec2AmiResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_RESOURCES_FIELD,
            LAMBDA_RESOURCES_FIELD, EC2_AMI_RESOURCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<S3Resource> s3Resources;

    private final List<LambdaResource> lambdaResources;

    private final List<Ec2AmiResource> ec2AmiResources;

    private JobResource(BuilderImpl builder) {
        this.s3Resources = builder.s3Resources;
        this.lambdaResources = builder.lambdaResources;
        this.ec2AmiResources = builder.ec2AmiResources;
    }

    /**
     * For responses, this returns true if the service returned a value for the S3Resources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasS3Resources() {
        return s3Resources != null && !(s3Resources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>S3Resource</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasS3Resources} method.
     * </p>
     * 
     * @return An array of <code>S3Resource</code> objects.
     */
    public final List<S3Resource> s3Resources() {
        return s3Resources;
    }

    /**
     * For responses, this returns true if the service returned a value for the LambdaResources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLambdaResources() {
        return lambdaResources != null && !(lambdaResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Python-language Lambda functions for this job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLambdaResources} method.
     * </p>
     * 
     * @return The Python-language Lambda functions for this job.
     */
    public final List<LambdaResource> lambdaResources() {
        return lambdaResources;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ec2AmiResources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEc2AmiResources() {
        return ec2AmiResources != null && !(ec2AmiResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Machine Images (AMIs) associated with this job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEc2AmiResources} method.
     * </p>
     * 
     * @return The Amazon Machine Images (AMIs) associated with this job.
     */
    public final List<Ec2AmiResource> ec2AmiResources() {
        return ec2AmiResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasS3Resources() ? s3Resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLambdaResources() ? lambdaResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEc2AmiResources() ? ec2AmiResources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobResource)) {
            return false;
        }
        JobResource other = (JobResource) obj;
        return hasS3Resources() == other.hasS3Resources() && Objects.equals(s3Resources(), other.s3Resources())
                && hasLambdaResources() == other.hasLambdaResources()
                && Objects.equals(lambdaResources(), other.lambdaResources())
                && hasEc2AmiResources() == other.hasEc2AmiResources()
                && Objects.equals(ec2AmiResources(), other.ec2AmiResources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobResource").add("S3Resources", hasS3Resources() ? s3Resources() : null)
                .add("LambdaResources", hasLambdaResources() ? lambdaResources() : null)
                .add("Ec2AmiResources", hasEc2AmiResources() ? ec2AmiResources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Resources":
            return Optional.ofNullable(clazz.cast(s3Resources()));
        case "LambdaResources":
            return Optional.ofNullable(clazz.cast(lambdaResources()));
        case "Ec2AmiResources":
            return Optional.ofNullable(clazz.cast(ec2AmiResources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("S3Resources", S3_RESOURCES_FIELD);
        map.put("LambdaResources", LAMBDA_RESOURCES_FIELD);
        map.put("Ec2AmiResources", EC2_AMI_RESOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobResource, T> g) {
        return obj -> g.apply((JobResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobResource> {
        /**
         * <p>
         * An array of <code>S3Resource</code> objects.
         * </p>
         * 
         * @param s3Resources
         *        An array of <code>S3Resource</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Resources(Collection<S3Resource> s3Resources);

        /**
         * <p>
         * An array of <code>S3Resource</code> objects.
         * </p>
         * 
         * @param s3Resources
         *        An array of <code>S3Resource</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Resources(S3Resource... s3Resources);

        /**
         * <p>
         * An array of <code>S3Resource</code> objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.snowball.model.S3Resource.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.snowball.model.S3Resource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.snowball.model.S3Resource.Builder#build()} is called immediately and
         * its result is passed to {@link #s3Resources(List<S3Resource>)}.
         * 
         * @param s3Resources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.snowball.model.S3Resource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Resources(java.util.Collection<S3Resource>)
         */
        Builder s3Resources(Consumer<S3Resource.Builder>... s3Resources);

        /**
         * <p>
         * The Python-language Lambda functions for this job.
         * </p>
         * 
         * @param lambdaResources
         *        The Python-language Lambda functions for this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaResources(Collection<LambdaResource> lambdaResources);

        /**
         * <p>
         * The Python-language Lambda functions for this job.
         * </p>
         * 
         * @param lambdaResources
         *        The Python-language Lambda functions for this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaResources(LambdaResource... lambdaResources);

        /**
         * <p>
         * The Python-language Lambda functions for this job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.snowball.model.LambdaResource.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.snowball.model.LambdaResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.snowball.model.LambdaResource.Builder#build()} is called immediately
         * and its result is passed to {@link #lambdaResources(List<LambdaResource>)}.
         * 
         * @param lambdaResources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.snowball.model.LambdaResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaResources(java.util.Collection<LambdaResource>)
         */
        Builder lambdaResources(Consumer<LambdaResource.Builder>... lambdaResources);

        /**
         * <p>
         * The Amazon Machine Images (AMIs) associated with this job.
         * </p>
         * 
         * @param ec2AmiResources
         *        The Amazon Machine Images (AMIs) associated with this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2AmiResources(Collection<Ec2AmiResource> ec2AmiResources);

        /**
         * <p>
         * The Amazon Machine Images (AMIs) associated with this job.
         * </p>
         * 
         * @param ec2AmiResources
         *        The Amazon Machine Images (AMIs) associated with this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2AmiResources(Ec2AmiResource... ec2AmiResources);

        /**
         * <p>
         * The Amazon Machine Images (AMIs) associated with this job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.snowball.model.Ec2AmiResource.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.snowball.model.Ec2AmiResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.snowball.model.Ec2AmiResource.Builder#build()} is called immediately
         * and its result is passed to {@link #ec2AmiResources(List<Ec2AmiResource>)}.
         * 
         * @param ec2AmiResources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.snowball.model.Ec2AmiResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2AmiResources(java.util.Collection<Ec2AmiResource>)
         */
        Builder ec2AmiResources(Consumer<Ec2AmiResource.Builder>... ec2AmiResources);
    }

    static final class BuilderImpl implements Builder {
        private List<S3Resource> s3Resources = DefaultSdkAutoConstructList.getInstance();

        private List<LambdaResource> lambdaResources = DefaultSdkAutoConstructList.getInstance();

        private List<Ec2AmiResource> ec2AmiResources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JobResource model) {
            s3Resources(model.s3Resources);
            lambdaResources(model.lambdaResources);
            ec2AmiResources(model.ec2AmiResources);
        }

        public final List<S3Resource.Builder> getS3Resources() {
            List<S3Resource.Builder> result = S3ResourceListCopier.copyToBuilder(this.s3Resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setS3Resources(Collection<S3Resource.BuilderImpl> s3Resources) {
            this.s3Resources = S3ResourceListCopier.copyFromBuilder(s3Resources);
        }

        @Override
        public final Builder s3Resources(Collection<S3Resource> s3Resources) {
            this.s3Resources = S3ResourceListCopier.copy(s3Resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Resources(S3Resource... s3Resources) {
            s3Resources(Arrays.asList(s3Resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Resources(Consumer<S3Resource.Builder>... s3Resources) {
            s3Resources(Stream.of(s3Resources).map(c -> S3Resource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<LambdaResource.Builder> getLambdaResources() {
            List<LambdaResource.Builder> result = LambdaResourceListCopier.copyToBuilder(this.lambdaResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLambdaResources(Collection<LambdaResource.BuilderImpl> lambdaResources) {
            this.lambdaResources = LambdaResourceListCopier.copyFromBuilder(lambdaResources);
        }

        @Override
        public final Builder lambdaResources(Collection<LambdaResource> lambdaResources) {
            this.lambdaResources = LambdaResourceListCopier.copy(lambdaResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lambdaResources(LambdaResource... lambdaResources) {
            lambdaResources(Arrays.asList(lambdaResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lambdaResources(Consumer<LambdaResource.Builder>... lambdaResources) {
            lambdaResources(Stream.of(lambdaResources).map(c -> LambdaResource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Ec2AmiResource.Builder> getEc2AmiResources() {
            List<Ec2AmiResource.Builder> result = Ec2AmiResourceListCopier.copyToBuilder(this.ec2AmiResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEc2AmiResources(Collection<Ec2AmiResource.BuilderImpl> ec2AmiResources) {
            this.ec2AmiResources = Ec2AmiResourceListCopier.copyFromBuilder(ec2AmiResources);
        }

        @Override
        public final Builder ec2AmiResources(Collection<Ec2AmiResource> ec2AmiResources) {
            this.ec2AmiResources = Ec2AmiResourceListCopier.copy(ec2AmiResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2AmiResources(Ec2AmiResource... ec2AmiResources) {
            ec2AmiResources(Arrays.asList(ec2AmiResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2AmiResources(Consumer<Ec2AmiResource.Builder>... ec2AmiResources) {
            ec2AmiResources(Stream.of(ec2AmiResources).map(c -> Ec2AmiResource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public JobResource build() {
            return new JobResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
