/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.snowball.model.DependentService;
import software.amazon.awssdk.services.snowball.model.DependentServiceListCopier;
import software.amazon.awssdk.services.snowball.model.ServiceName;
import software.amazon.awssdk.services.snowball.model.ServiceVersion;
import software.amazon.awssdk.services.snowball.model.ServiceVersionListCopier;
import software.amazon.awssdk.services.snowball.model.SnowballResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListServiceVersionsResponse
extends SnowballResponse
implements ToCopyableBuilder<Builder, ListServiceVersionsResponse> {
    private static final SdkField<List<ServiceVersion>> SERVICE_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ServiceVersions").getter(ListServiceVersionsResponse.getter(ListServiceVersionsResponse::serviceVersions)).setter(ListServiceVersionsResponse.setter(Builder::serviceVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceName").getter(ListServiceVersionsResponse.getter(ListServiceVersionsResponse::serviceNameAsString)).setter(ListServiceVersionsResponse.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()}).build();
    private static final SdkField<List<DependentService>> DEPENDENT_SERVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DependentServices").getter(ListServiceVersionsResponse.getter(ListServiceVersionsResponse::dependentServices)).setter(ListServiceVersionsResponse.setter(Builder::dependentServices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DependentServices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DependentService::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListServiceVersionsResponse.getter(ListServiceVersionsResponse::nextToken)).setter(ListServiceVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_VERSIONS_FIELD, SERVICE_NAME_FIELD, DEPENDENT_SERVICES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListServiceVersionsResponse.memberNameToFieldInitializer();
    private final List<ServiceVersion> serviceVersions;
    private final String serviceName;
    private final List<DependentService> dependentServices;
    private final String nextToken;

    private ListServiceVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.serviceVersions = builder.serviceVersions;
        this.serviceName = builder.serviceName;
        this.dependentServices = builder.dependentServices;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasServiceVersions() {
        return this.serviceVersions != null && !(this.serviceVersions instanceof SdkAutoConstructList);
    }

    public final List<ServiceVersion> serviceVersions() {
        return this.serviceVersions;
    }

    public final ServiceName serviceName() {
        return ServiceName.fromValue(this.serviceName);
    }

    public final String serviceNameAsString() {
        return this.serviceName;
    }

    public final boolean hasDependentServices() {
        return this.dependentServices != null && !(this.dependentServices instanceof SdkAutoConstructList);
    }

    public final List<DependentService> dependentServices() {
        return this.dependentServices;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceVersions() ? this.serviceVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDependentServices() ? this.dependentServices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceVersionsResponse)) {
            return false;
        }
        ListServiceVersionsResponse other = (ListServiceVersionsResponse)((Object)obj);
        return this.hasServiceVersions() == other.hasServiceVersions() && Objects.equals(this.serviceVersions(), other.serviceVersions()) && Objects.equals(this.serviceNameAsString(), other.serviceNameAsString()) && this.hasDependentServices() == other.hasDependentServices() && Objects.equals(this.dependentServices(), other.dependentServices()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListServiceVersionsResponse").add("ServiceVersions", this.hasServiceVersions() ? this.serviceVersions() : null).add("ServiceName", (Object)this.serviceNameAsString()).add("DependentServices", this.hasDependentServices() ? this.dependentServices() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceVersions": {
                return Optional.ofNullable(clazz.cast(this.serviceVersions()));
            }
            case "ServiceName": {
                return Optional.ofNullable(clazz.cast(this.serviceNameAsString()));
            }
            case "DependentServices": {
                return Optional.ofNullable(clazz.cast(this.dependentServices()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ServiceVersions", SERVICE_VERSIONS_FIELD);
        map.put("ServiceName", SERVICE_NAME_FIELD);
        map.put("DependentServices", DEPENDENT_SERVICES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListServiceVersionsResponse, T> g) {
        return obj -> g.apply((ListServiceVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SnowballResponse.BuilderImpl
    implements Builder {
        private List<ServiceVersion> serviceVersions = DefaultSdkAutoConstructList.getInstance();
        private String serviceName;
        private List<DependentService> dependentServices = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceVersionsResponse model) {
            super(model);
            this.serviceVersions(model.serviceVersions);
            this.serviceName(model.serviceName);
            this.dependentServices(model.dependentServices);
            this.nextToken(model.nextToken);
        }

        public final List<ServiceVersion.Builder> getServiceVersions() {
            List<ServiceVersion.Builder> result = ServiceVersionListCopier.copyToBuilder(this.serviceVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceVersions(Collection<ServiceVersion.BuilderImpl> serviceVersions) {
            this.serviceVersions = ServiceVersionListCopier.copyFromBuilder(serviceVersions);
        }

        @Override
        public final Builder serviceVersions(Collection<ServiceVersion> serviceVersions) {
            this.serviceVersions = ServiceVersionListCopier.copy(serviceVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceVersions(ServiceVersion ... serviceVersions) {
            this.serviceVersions(Arrays.asList(serviceVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceVersions(Consumer<ServiceVersion.Builder> ... serviceVersions) {
            this.serviceVersions(Stream.of(serviceVersions).map(c -> (ServiceVersion)((ServiceVersion.Builder)ServiceVersion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        @Override
        public final Builder serviceName(ServiceName serviceName) {
            this.serviceName(serviceName == null ? null : serviceName.toString());
            return this;
        }

        public final List<DependentService.Builder> getDependentServices() {
            List<DependentService.Builder> result = DependentServiceListCopier.copyToBuilder(this.dependentServices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDependentServices(Collection<DependentService.BuilderImpl> dependentServices) {
            this.dependentServices = DependentServiceListCopier.copyFromBuilder(dependentServices);
        }

        @Override
        public final Builder dependentServices(Collection<DependentService> dependentServices) {
            this.dependentServices = DependentServiceListCopier.copy(dependentServices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependentServices(DependentService ... dependentServices) {
            this.dependentServices(Arrays.asList(dependentServices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependentServices(Consumer<DependentService.Builder> ... dependentServices) {
            this.dependentServices(Stream.of(dependentServices).map(c -> (DependentService)((DependentService.Builder)DependentService.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListServiceVersionsResponse build() {
            return new ListServiceVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SnowballResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListServiceVersionsResponse> {
        public Builder serviceVersions(Collection<ServiceVersion> var1);

        public Builder serviceVersions(ServiceVersion ... var1);

        public Builder serviceVersions(Consumer<ServiceVersion.Builder> ... var1);

        public Builder serviceName(String var1);

        public Builder serviceName(ServiceName var1);

        public Builder dependentServices(Collection<DependentService> var1);

        public Builder dependentServices(DependentService ... var1);

        public Builder dependentServices(Consumer<DependentService.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

