/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ImpactLevel {
    IL2("IL2"),
    IL4("IL4"),
    IL5("IL5"),
    IL6("IL6"),
    IL99("IL99"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ImpactLevel> VALUE_MAP;
    private final String value;

    private ImpactLevel(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ImpactLevel fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ImpactLevel> knownValues() {
        EnumSet<ImpactLevel> knownValues = EnumSet.allOf(ImpactLevel.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ImpactLevel.class, ImpactLevel::toString);
    }
}

