/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EKSOnDeviceServiceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EKSOnDeviceServiceConfiguration> {
    private static final SdkField<String> KUBERNETES_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KubernetesVersion").getter(EKSOnDeviceServiceConfiguration.getter(EKSOnDeviceServiceConfiguration::kubernetesVersion)).setter(EKSOnDeviceServiceConfiguration.setter(Builder::kubernetesVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KubernetesVersion").build()}).build();
    private static final SdkField<String> EKS_ANYWHERE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EKSAnywhereVersion").getter(EKSOnDeviceServiceConfiguration.getter(EKSOnDeviceServiceConfiguration::eksAnywhereVersion)).setter(EKSOnDeviceServiceConfiguration.setter(Builder::eksAnywhereVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EKSAnywhereVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KUBERNETES_VERSION_FIELD, EKS_ANYWHERE_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("KubernetesVersion", KUBERNETES_VERSION_FIELD);
            this.put("EKSAnywhereVersion", EKS_ANYWHERE_VERSION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String kubernetesVersion;
    private final String eksAnywhereVersion;

    private EKSOnDeviceServiceConfiguration(BuilderImpl builder) {
        this.kubernetesVersion = builder.kubernetesVersion;
        this.eksAnywhereVersion = builder.eksAnywhereVersion;
    }

    public final String kubernetesVersion() {
        return this.kubernetesVersion;
    }

    public final String eksAnywhereVersion() {
        return this.eksAnywhereVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.kubernetesVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.eksAnywhereVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EKSOnDeviceServiceConfiguration)) {
            return false;
        }
        EKSOnDeviceServiceConfiguration other = (EKSOnDeviceServiceConfiguration)obj;
        return Objects.equals(this.kubernetesVersion(), other.kubernetesVersion()) && Objects.equals(this.eksAnywhereVersion(), other.eksAnywhereVersion());
    }

    public final String toString() {
        return ToString.builder((String)"EKSOnDeviceServiceConfiguration").add("KubernetesVersion", (Object)this.kubernetesVersion()).add("EKSAnywhereVersion", (Object)this.eksAnywhereVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KubernetesVersion": {
                return Optional.ofNullable(clazz.cast(this.kubernetesVersion()));
            }
            case "EKSAnywhereVersion": {
                return Optional.ofNullable(clazz.cast(this.eksAnywhereVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EKSOnDeviceServiceConfiguration, T> g) {
        return obj -> g.apply((EKSOnDeviceServiceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String kubernetesVersion;
        private String eksAnywhereVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(EKSOnDeviceServiceConfiguration model) {
            this.kubernetesVersion(model.kubernetesVersion);
            this.eksAnywhereVersion(model.eksAnywhereVersion);
        }

        public final String getKubernetesVersion() {
            return this.kubernetesVersion;
        }

        public final void setKubernetesVersion(String kubernetesVersion) {
            this.kubernetesVersion = kubernetesVersion;
        }

        @Override
        public final Builder kubernetesVersion(String kubernetesVersion) {
            this.kubernetesVersion = kubernetesVersion;
            return this;
        }

        public final String getEksAnywhereVersion() {
            return this.eksAnywhereVersion;
        }

        public final void setEksAnywhereVersion(String eksAnywhereVersion) {
            this.eksAnywhereVersion = eksAnywhereVersion;
        }

        @Override
        public final Builder eksAnywhereVersion(String eksAnywhereVersion) {
            this.eksAnywhereVersion = eksAnywhereVersion;
            return this;
        }

        public EKSOnDeviceServiceConfiguration build() {
            return new EKSOnDeviceServiceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EKSOnDeviceServiceConfiguration> {
        public Builder kubernetesVersion(String var1);

        public Builder eksAnywhereVersion(String var1);
    }
}

