/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.snowball.model.StorageUnit;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3OnDeviceServiceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3OnDeviceServiceConfiguration> {
    private static final SdkField<Double> STORAGE_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("StorageLimit").getter(S3OnDeviceServiceConfiguration.getter(S3OnDeviceServiceConfiguration::storageLimit)).setter(S3OnDeviceServiceConfiguration.setter(Builder::storageLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageLimit").build()}).build();
    private static final SdkField<String> STORAGE_UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageUnit").getter(S3OnDeviceServiceConfiguration.getter(S3OnDeviceServiceConfiguration::storageUnitAsString)).setter(S3OnDeviceServiceConfiguration.setter(Builder::storageUnit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageUnit").build()}).build();
    private static final SdkField<Integer> SERVICE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ServiceSize").getter(S3OnDeviceServiceConfiguration.getter(S3OnDeviceServiceConfiguration::serviceSize)).setter(S3OnDeviceServiceConfiguration.setter(Builder::serviceSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceSize").build()}).build();
    private static final SdkField<Integer> FAULT_TOLERANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FaultTolerance").getter(S3OnDeviceServiceConfiguration.getter(S3OnDeviceServiceConfiguration::faultTolerance)).setter(S3OnDeviceServiceConfiguration.setter(Builder::faultTolerance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaultTolerance").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_LIMIT_FIELD, STORAGE_UNIT_FIELD, SERVICE_SIZE_FIELD, FAULT_TOLERANCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("StorageLimit", STORAGE_LIMIT_FIELD);
            this.put("StorageUnit", STORAGE_UNIT_FIELD);
            this.put("ServiceSize", SERVICE_SIZE_FIELD);
            this.put("FaultTolerance", FAULT_TOLERANCE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Double storageLimit;
    private final String storageUnit;
    private final Integer serviceSize;
    private final Integer faultTolerance;

    private S3OnDeviceServiceConfiguration(BuilderImpl builder) {
        this.storageLimit = builder.storageLimit;
        this.storageUnit = builder.storageUnit;
        this.serviceSize = builder.serviceSize;
        this.faultTolerance = builder.faultTolerance;
    }

    public final Double storageLimit() {
        return this.storageLimit;
    }

    public final StorageUnit storageUnit() {
        return StorageUnit.fromValue(this.storageUnit);
    }

    public final String storageUnitAsString() {
        return this.storageUnit;
    }

    public final Integer serviceSize() {
        return this.serviceSize;
    }

    public final Integer faultTolerance() {
        return this.faultTolerance;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.storageLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.faultTolerance());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3OnDeviceServiceConfiguration)) {
            return false;
        }
        S3OnDeviceServiceConfiguration other = (S3OnDeviceServiceConfiguration)obj;
        return Objects.equals(this.storageLimit(), other.storageLimit()) && Objects.equals(this.storageUnitAsString(), other.storageUnitAsString()) && Objects.equals(this.serviceSize(), other.serviceSize()) && Objects.equals(this.faultTolerance(), other.faultTolerance());
    }

    public final String toString() {
        return ToString.builder((String)"S3OnDeviceServiceConfiguration").add("StorageLimit", (Object)this.storageLimit()).add("StorageUnit", (Object)this.storageUnitAsString()).add("ServiceSize", (Object)this.serviceSize()).add("FaultTolerance", (Object)this.faultTolerance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StorageLimit": {
                return Optional.ofNullable(clazz.cast(this.storageLimit()));
            }
            case "StorageUnit": {
                return Optional.ofNullable(clazz.cast(this.storageUnitAsString()));
            }
            case "ServiceSize": {
                return Optional.ofNullable(clazz.cast(this.serviceSize()));
            }
            case "FaultTolerance": {
                return Optional.ofNullable(clazz.cast(this.faultTolerance()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<S3OnDeviceServiceConfiguration, T> g) {
        return obj -> g.apply((S3OnDeviceServiceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double storageLimit;
        private String storageUnit;
        private Integer serviceSize;
        private Integer faultTolerance;

        private BuilderImpl() {
        }

        private BuilderImpl(S3OnDeviceServiceConfiguration model) {
            this.storageLimit(model.storageLimit);
            this.storageUnit(model.storageUnit);
            this.serviceSize(model.serviceSize);
            this.faultTolerance(model.faultTolerance);
        }

        public final Double getStorageLimit() {
            return this.storageLimit;
        }

        public final void setStorageLimit(Double storageLimit) {
            this.storageLimit = storageLimit;
        }

        @Override
        public final Builder storageLimit(Double storageLimit) {
            this.storageLimit = storageLimit;
            return this;
        }

        public final String getStorageUnit() {
            return this.storageUnit;
        }

        public final void setStorageUnit(String storageUnit) {
            this.storageUnit = storageUnit;
        }

        @Override
        public final Builder storageUnit(String storageUnit) {
            this.storageUnit = storageUnit;
            return this;
        }

        @Override
        public final Builder storageUnit(StorageUnit storageUnit) {
            this.storageUnit(storageUnit == null ? null : storageUnit.toString());
            return this;
        }

        public final Integer getServiceSize() {
            return this.serviceSize;
        }

        public final void setServiceSize(Integer serviceSize) {
            this.serviceSize = serviceSize;
        }

        @Override
        public final Builder serviceSize(Integer serviceSize) {
            this.serviceSize = serviceSize;
            return this;
        }

        public final Integer getFaultTolerance() {
            return this.faultTolerance;
        }

        public final void setFaultTolerance(Integer faultTolerance) {
            this.faultTolerance = faultTolerance;
        }

        @Override
        public final Builder faultTolerance(Integer faultTolerance) {
            this.faultTolerance = faultTolerance;
            return this;
        }

        public S3OnDeviceServiceConfiguration build() {
            return new S3OnDeviceServiceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3OnDeviceServiceConfiguration> {
        public Builder storageLimit(Double var1);

        public Builder storageUnit(String var1);

        public Builder storageUnit(StorageUnit var1);

        public Builder serviceSize(Integer var1);

        public Builder faultTolerance(Integer var1);
    }
}

