/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.snowball.SnowballAsyncClient;
import software.amazon.awssdk.services.snowball.internal.UserAgentUtils;
import software.amazon.awssdk.services.snowball.model.JobListEntry;
import software.amazon.awssdk.services.snowball.model.ListClusterJobsRequest;
import software.amazon.awssdk.services.snowball.model.ListClusterJobsResponse;

public class ListClusterJobsPublisher
implements SdkPublisher<ListClusterJobsResponse> {
    private final SnowballAsyncClient client;
    private final ListClusterJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListClusterJobsPublisher(SnowballAsyncClient client, ListClusterJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListClusterJobsPublisher(SnowballAsyncClient client, ListClusterJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListClusterJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListClusterJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<JobListEntry> jobListEntries() {
        Function<ListClusterJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobListEntries() != null) {
                return response.jobListEntries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListClusterJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListClusterJobsResponseFetcher
    implements AsyncPageFetcher<ListClusterJobsResponse> {
        private ListClusterJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListClusterJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListClusterJobsResponse> nextPage(ListClusterJobsResponse previousPage) {
            if (previousPage == null) {
                return ListClusterJobsPublisher.this.client.listClusterJobs(ListClusterJobsPublisher.this.firstRequest);
            }
            return ListClusterJobsPublisher.this.client.listClusterJobs((ListClusterJobsRequest)((Object)ListClusterJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

