/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SnowballType {
    STANDARD("STANDARD"),
    EDGE("EDGE"),
    EDGE_C("EDGE_C"),
    EDGE_CG("EDGE_CG"),
    EDGE_S("EDGE_S"),
    SNC1_HDD("SNC1_HDD"),
    SNC1_SSD("SNC1_SSD"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SnowballType> VALUE_MAP;
    private final String value;

    private SnowballType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SnowballType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SnowballType> knownValues() {
        EnumSet<SnowballType> knownValues = EnumSet.allOf(SnowballType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SnowballType.class, SnowballType::toString);
    }
}

