/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.snowball.model.DeviceConfiguration;
import software.amazon.awssdk.services.snowball.model.JobResource;
import software.amazon.awssdk.services.snowball.model.JobType;
import software.amazon.awssdk.services.snowball.model.Notification;
import software.amazon.awssdk.services.snowball.model.OnDeviceServiceConfiguration;
import software.amazon.awssdk.services.snowball.model.RemoteManagement;
import software.amazon.awssdk.services.snowball.model.ShippingOption;
import software.amazon.awssdk.services.snowball.model.SnowballCapacity;
import software.amazon.awssdk.services.snowball.model.SnowballRequest;
import software.amazon.awssdk.services.snowball.model.SnowballType;
import software.amazon.awssdk.services.snowball.model.TaxDocuments;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateJobRequest
extends SnowballRequest
implements ToCopyableBuilder<Builder, CreateJobRequest> {
    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobType").getter(CreateJobRequest.getter(CreateJobRequest::jobTypeAsString)).setter(CreateJobRequest.setter(Builder::jobType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobType").build()}).build();
    private static final SdkField<JobResource> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Resources").getter(CreateJobRequest.getter(CreateJobRequest::resources)).setter(CreateJobRequest.setter(Builder::resources)).constructor(JobResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resources").build()}).build();
    private static final SdkField<OnDeviceServiceConfiguration> ON_DEVICE_SERVICE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OnDeviceServiceConfiguration").getter(CreateJobRequest.getter(CreateJobRequest::onDeviceServiceConfiguration)).setter(CreateJobRequest.setter(Builder::onDeviceServiceConfiguration)).constructor(OnDeviceServiceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDeviceServiceConfiguration").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateJobRequest.getter(CreateJobRequest::description)).setter(CreateJobRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ADDRESS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AddressId").getter(CreateJobRequest.getter(CreateJobRequest::addressId)).setter(CreateJobRequest.setter(Builder::addressId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressId").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyARN").getter(CreateJobRequest.getter(CreateJobRequest::kmsKeyARN)).setter(CreateJobRequest.setter(Builder::kmsKeyARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyARN").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleARN").getter(CreateJobRequest.getter(CreateJobRequest::roleARN)).setter(CreateJobRequest.setter(Builder::roleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()}).build();
    private static final SdkField<String> SNOWBALL_CAPACITY_PREFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnowballCapacityPreference").getter(CreateJobRequest.getter(CreateJobRequest::snowballCapacityPreferenceAsString)).setter(CreateJobRequest.setter(Builder::snowballCapacityPreference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnowballCapacityPreference").build()}).build();
    private static final SdkField<String> SHIPPING_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShippingOption").getter(CreateJobRequest.getter(CreateJobRequest::shippingOptionAsString)).setter(CreateJobRequest.setter(Builder::shippingOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShippingOption").build()}).build();
    private static final SdkField<Notification> NOTIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Notification").getter(CreateJobRequest.getter(CreateJobRequest::notification)).setter(CreateJobRequest.setter(Builder::notification)).constructor(Notification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notification").build()}).build();
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterId").getter(CreateJobRequest.getter(CreateJobRequest::clusterId)).setter(CreateJobRequest.setter(Builder::clusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()}).build();
    private static final SdkField<String> SNOWBALL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnowballType").getter(CreateJobRequest.getter(CreateJobRequest::snowballTypeAsString)).setter(CreateJobRequest.setter(Builder::snowballType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnowballType").build()}).build();
    private static final SdkField<String> FORWARDING_ADDRESS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ForwardingAddressId").getter(CreateJobRequest.getter(CreateJobRequest::forwardingAddressId)).setter(CreateJobRequest.setter(Builder::forwardingAddressId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForwardingAddressId").build()}).build();
    private static final SdkField<TaxDocuments> TAX_DOCUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TaxDocuments").getter(CreateJobRequest.getter(CreateJobRequest::taxDocuments)).setter(CreateJobRequest.setter(Builder::taxDocuments)).constructor(TaxDocuments::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaxDocuments").build()}).build();
    private static final SdkField<DeviceConfiguration> DEVICE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeviceConfiguration").getter(CreateJobRequest.getter(CreateJobRequest::deviceConfiguration)).setter(CreateJobRequest.setter(Builder::deviceConfiguration)).constructor(DeviceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceConfiguration").build()}).build();
    private static final SdkField<String> REMOTE_MANAGEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RemoteManagement").getter(CreateJobRequest.getter(CreateJobRequest::remoteManagementAsString)).setter(CreateJobRequest.setter(Builder::remoteManagement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteManagement").build()}).build();
    private static final SdkField<String> LONG_TERM_PRICING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LongTermPricingId").getter(CreateJobRequest.getter(CreateJobRequest::longTermPricingId)).setter(CreateJobRequest.setter(Builder::longTermPricingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LongTermPricingId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_TYPE_FIELD, RESOURCES_FIELD, ON_DEVICE_SERVICE_CONFIGURATION_FIELD, DESCRIPTION_FIELD, ADDRESS_ID_FIELD, KMS_KEY_ARN_FIELD, ROLE_ARN_FIELD, SNOWBALL_CAPACITY_PREFERENCE_FIELD, SHIPPING_OPTION_FIELD, NOTIFICATION_FIELD, CLUSTER_ID_FIELD, SNOWBALL_TYPE_FIELD, FORWARDING_ADDRESS_ID_FIELD, TAX_DOCUMENTS_FIELD, DEVICE_CONFIGURATION_FIELD, REMOTE_MANAGEMENT_FIELD, LONG_TERM_PRICING_ID_FIELD));
    private final String jobType;
    private final JobResource resources;
    private final OnDeviceServiceConfiguration onDeviceServiceConfiguration;
    private final String description;
    private final String addressId;
    private final String kmsKeyARN;
    private final String roleARN;
    private final String snowballCapacityPreference;
    private final String shippingOption;
    private final Notification notification;
    private final String clusterId;
    private final String snowballType;
    private final String forwardingAddressId;
    private final TaxDocuments taxDocuments;
    private final DeviceConfiguration deviceConfiguration;
    private final String remoteManagement;
    private final String longTermPricingId;

    private CreateJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobType = builder.jobType;
        this.resources = builder.resources;
        this.onDeviceServiceConfiguration = builder.onDeviceServiceConfiguration;
        this.description = builder.description;
        this.addressId = builder.addressId;
        this.kmsKeyARN = builder.kmsKeyARN;
        this.roleARN = builder.roleARN;
        this.snowballCapacityPreference = builder.snowballCapacityPreference;
        this.shippingOption = builder.shippingOption;
        this.notification = builder.notification;
        this.clusterId = builder.clusterId;
        this.snowballType = builder.snowballType;
        this.forwardingAddressId = builder.forwardingAddressId;
        this.taxDocuments = builder.taxDocuments;
        this.deviceConfiguration = builder.deviceConfiguration;
        this.remoteManagement = builder.remoteManagement;
        this.longTermPricingId = builder.longTermPricingId;
    }

    public final JobType jobType() {
        return JobType.fromValue(this.jobType);
    }

    public final String jobTypeAsString() {
        return this.jobType;
    }

    public final JobResource resources() {
        return this.resources;
    }

    public final OnDeviceServiceConfiguration onDeviceServiceConfiguration() {
        return this.onDeviceServiceConfiguration;
    }

    public final String description() {
        return this.description;
    }

    public final String addressId() {
        return this.addressId;
    }

    public final String kmsKeyARN() {
        return this.kmsKeyARN;
    }

    public final String roleARN() {
        return this.roleARN;
    }

    public final SnowballCapacity snowballCapacityPreference() {
        return SnowballCapacity.fromValue(this.snowballCapacityPreference);
    }

    public final String snowballCapacityPreferenceAsString() {
        return this.snowballCapacityPreference;
    }

    public final ShippingOption shippingOption() {
        return ShippingOption.fromValue(this.shippingOption);
    }

    public final String shippingOptionAsString() {
        return this.shippingOption;
    }

    public final Notification notification() {
        return this.notification;
    }

    public final String clusterId() {
        return this.clusterId;
    }

    public final SnowballType snowballType() {
        return SnowballType.fromValue(this.snowballType);
    }

    public final String snowballTypeAsString() {
        return this.snowballType;
    }

    public final String forwardingAddressId() {
        return this.forwardingAddressId;
    }

    public final TaxDocuments taxDocuments() {
        return this.taxDocuments;
    }

    public final DeviceConfiguration deviceConfiguration() {
        return this.deviceConfiguration;
    }

    public final RemoteManagement remoteManagement() {
        return RemoteManagement.fromValue(this.remoteManagement);
    }

    public final String remoteManagementAsString() {
        return this.remoteManagement;
    }

    public final String longTermPricingId() {
        return this.longTermPricingId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resources());
        hashCode = 31 * hashCode + Objects.hashCode(this.onDeviceServiceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressId());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.snowballCapacityPreferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.shippingOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.notification());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.snowballTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.forwardingAddressId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taxDocuments());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteManagementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.longTermPricingId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobRequest)) {
            return false;
        }
        CreateJobRequest other = (CreateJobRequest)((Object)obj);
        return Objects.equals(this.jobTypeAsString(), other.jobTypeAsString()) && Objects.equals(this.resources(), other.resources()) && Objects.equals(this.onDeviceServiceConfiguration(), other.onDeviceServiceConfiguration()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.addressId(), other.addressId()) && Objects.equals(this.kmsKeyARN(), other.kmsKeyARN()) && Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.snowballCapacityPreferenceAsString(), other.snowballCapacityPreferenceAsString()) && Objects.equals(this.shippingOptionAsString(), other.shippingOptionAsString()) && Objects.equals(this.notification(), other.notification()) && Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.snowballTypeAsString(), other.snowballTypeAsString()) && Objects.equals(this.forwardingAddressId(), other.forwardingAddressId()) && Objects.equals(this.taxDocuments(), other.taxDocuments()) && Objects.equals(this.deviceConfiguration(), other.deviceConfiguration()) && Objects.equals(this.remoteManagementAsString(), other.remoteManagementAsString()) && Objects.equals(this.longTermPricingId(), other.longTermPricingId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateJobRequest").add("JobType", (Object)this.jobTypeAsString()).add("Resources", (Object)this.resources()).add("OnDeviceServiceConfiguration", (Object)this.onDeviceServiceConfiguration()).add("Description", (Object)this.description()).add("AddressId", (Object)this.addressId()).add("KmsKeyARN", (Object)this.kmsKeyARN()).add("RoleARN", (Object)this.roleARN()).add("SnowballCapacityPreference", (Object)this.snowballCapacityPreferenceAsString()).add("ShippingOption", (Object)this.shippingOptionAsString()).add("Notification", (Object)this.notification()).add("ClusterId", (Object)this.clusterId()).add("SnowballType", (Object)this.snowballTypeAsString()).add("ForwardingAddressId", (Object)this.forwardingAddressId()).add("TaxDocuments", (Object)this.taxDocuments()).add("DeviceConfiguration", (Object)this.deviceConfiguration()).add("RemoteManagement", (Object)this.remoteManagementAsString()).add("LongTermPricingId", (Object)this.longTermPricingId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobType": {
                return Optional.ofNullable(clazz.cast(this.jobTypeAsString()));
            }
            case "Resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
            case "OnDeviceServiceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.onDeviceServiceConfiguration()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "AddressId": {
                return Optional.ofNullable(clazz.cast(this.addressId()));
            }
            case "KmsKeyARN": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyARN()));
            }
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "SnowballCapacityPreference": {
                return Optional.ofNullable(clazz.cast(this.snowballCapacityPreferenceAsString()));
            }
            case "ShippingOption": {
                return Optional.ofNullable(clazz.cast(this.shippingOptionAsString()));
            }
            case "Notification": {
                return Optional.ofNullable(clazz.cast(this.notification()));
            }
            case "ClusterId": {
                return Optional.ofNullable(clazz.cast(this.clusterId()));
            }
            case "SnowballType": {
                return Optional.ofNullable(clazz.cast(this.snowballTypeAsString()));
            }
            case "ForwardingAddressId": {
                return Optional.ofNullable(clazz.cast(this.forwardingAddressId()));
            }
            case "TaxDocuments": {
                return Optional.ofNullable(clazz.cast(this.taxDocuments()));
            }
            case "DeviceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.deviceConfiguration()));
            }
            case "RemoteManagement": {
                return Optional.ofNullable(clazz.cast(this.remoteManagementAsString()));
            }
            case "LongTermPricingId": {
                return Optional.ofNullable(clazz.cast(this.longTermPricingId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateJobRequest, T> g) {
        return obj -> g.apply((CreateJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SnowballRequest.BuilderImpl
    implements Builder {
        private String jobType;
        private JobResource resources;
        private OnDeviceServiceConfiguration onDeviceServiceConfiguration;
        private String description;
        private String addressId;
        private String kmsKeyARN;
        private String roleARN;
        private String snowballCapacityPreference;
        private String shippingOption;
        private Notification notification;
        private String clusterId;
        private String snowballType;
        private String forwardingAddressId;
        private TaxDocuments taxDocuments;
        private DeviceConfiguration deviceConfiguration;
        private String remoteManagement;
        private String longTermPricingId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateJobRequest model) {
            super(model);
            this.jobType(model.jobType);
            this.resources(model.resources);
            this.onDeviceServiceConfiguration(model.onDeviceServiceConfiguration);
            this.description(model.description);
            this.addressId(model.addressId);
            this.kmsKeyARN(model.kmsKeyARN);
            this.roleARN(model.roleARN);
            this.snowballCapacityPreference(model.snowballCapacityPreference);
            this.shippingOption(model.shippingOption);
            this.notification(model.notification);
            this.clusterId(model.clusterId);
            this.snowballType(model.snowballType);
            this.forwardingAddressId(model.forwardingAddressId);
            this.taxDocuments(model.taxDocuments);
            this.deviceConfiguration(model.deviceConfiguration);
            this.remoteManagement(model.remoteManagement);
            this.longTermPricingId(model.longTermPricingId);
        }

        public final String getJobType() {
            return this.jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        public final JobResource.Builder getResources() {
            return this.resources != null ? this.resources.toBuilder() : null;
        }

        @Override
        public final Builder resources(JobResource resources) {
            this.resources = resources;
            return this;
        }

        public final void setResources(JobResource.BuilderImpl resources) {
            this.resources = resources != null ? resources.build() : null;
        }

        public final OnDeviceServiceConfiguration.Builder getOnDeviceServiceConfiguration() {
            return this.onDeviceServiceConfiguration != null ? this.onDeviceServiceConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder onDeviceServiceConfiguration(OnDeviceServiceConfiguration onDeviceServiceConfiguration) {
            this.onDeviceServiceConfiguration = onDeviceServiceConfiguration;
            return this;
        }

        public final void setOnDeviceServiceConfiguration(OnDeviceServiceConfiguration.BuilderImpl onDeviceServiceConfiguration) {
            this.onDeviceServiceConfiguration = onDeviceServiceConfiguration != null ? onDeviceServiceConfiguration.build() : null;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getAddressId() {
            return this.addressId;
        }

        @Override
        public final Builder addressId(String addressId) {
            this.addressId = addressId;
            return this;
        }

        public final void setAddressId(String addressId) {
            this.addressId = addressId;
        }

        public final String getKmsKeyARN() {
            return this.kmsKeyARN;
        }

        @Override
        public final Builder kmsKeyARN(String kmsKeyARN) {
            this.kmsKeyARN = kmsKeyARN;
            return this;
        }

        public final void setKmsKeyARN(String kmsKeyARN) {
            this.kmsKeyARN = kmsKeyARN;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getSnowballCapacityPreference() {
            return this.snowballCapacityPreference;
        }

        @Override
        public final Builder snowballCapacityPreference(String snowballCapacityPreference) {
            this.snowballCapacityPreference = snowballCapacityPreference;
            return this;
        }

        @Override
        public final Builder snowballCapacityPreference(SnowballCapacity snowballCapacityPreference) {
            this.snowballCapacityPreference(snowballCapacityPreference == null ? null : snowballCapacityPreference.toString());
            return this;
        }

        public final void setSnowballCapacityPreference(String snowballCapacityPreference) {
            this.snowballCapacityPreference = snowballCapacityPreference;
        }

        public final String getShippingOption() {
            return this.shippingOption;
        }

        @Override
        public final Builder shippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
            return this;
        }

        @Override
        public final Builder shippingOption(ShippingOption shippingOption) {
            this.shippingOption(shippingOption == null ? null : shippingOption.toString());
            return this;
        }

        public final void setShippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
        }

        public final Notification.Builder getNotification() {
            return this.notification != null ? this.notification.toBuilder() : null;
        }

        @Override
        public final Builder notification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public final void setNotification(Notification.BuilderImpl notification) {
            this.notification = notification != null ? notification.build() : null;
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final String getSnowballType() {
            return this.snowballType;
        }

        @Override
        public final Builder snowballType(String snowballType) {
            this.snowballType = snowballType;
            return this;
        }

        @Override
        public final Builder snowballType(SnowballType snowballType) {
            this.snowballType(snowballType == null ? null : snowballType.toString());
            return this;
        }

        public final void setSnowballType(String snowballType) {
            this.snowballType = snowballType;
        }

        public final String getForwardingAddressId() {
            return this.forwardingAddressId;
        }

        @Override
        public final Builder forwardingAddressId(String forwardingAddressId) {
            this.forwardingAddressId = forwardingAddressId;
            return this;
        }

        public final void setForwardingAddressId(String forwardingAddressId) {
            this.forwardingAddressId = forwardingAddressId;
        }

        public final TaxDocuments.Builder getTaxDocuments() {
            return this.taxDocuments != null ? this.taxDocuments.toBuilder() : null;
        }

        @Override
        public final Builder taxDocuments(TaxDocuments taxDocuments) {
            this.taxDocuments = taxDocuments;
            return this;
        }

        public final void setTaxDocuments(TaxDocuments.BuilderImpl taxDocuments) {
            this.taxDocuments = taxDocuments != null ? taxDocuments.build() : null;
        }

        public final DeviceConfiguration.Builder getDeviceConfiguration() {
            return this.deviceConfiguration != null ? this.deviceConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder deviceConfiguration(DeviceConfiguration deviceConfiguration) {
            this.deviceConfiguration = deviceConfiguration;
            return this;
        }

        public final void setDeviceConfiguration(DeviceConfiguration.BuilderImpl deviceConfiguration) {
            this.deviceConfiguration = deviceConfiguration != null ? deviceConfiguration.build() : null;
        }

        public final String getRemoteManagement() {
            return this.remoteManagement;
        }

        @Override
        public final Builder remoteManagement(String remoteManagement) {
            this.remoteManagement = remoteManagement;
            return this;
        }

        @Override
        public final Builder remoteManagement(RemoteManagement remoteManagement) {
            this.remoteManagement(remoteManagement == null ? null : remoteManagement.toString());
            return this;
        }

        public final void setRemoteManagement(String remoteManagement) {
            this.remoteManagement = remoteManagement;
        }

        public final String getLongTermPricingId() {
            return this.longTermPricingId;
        }

        @Override
        public final Builder longTermPricingId(String longTermPricingId) {
            this.longTermPricingId = longTermPricingId;
            return this;
        }

        public final void setLongTermPricingId(String longTermPricingId) {
            this.longTermPricingId = longTermPricingId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateJobRequest build() {
            return new CreateJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SnowballRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateJobRequest> {
        public Builder jobType(String var1);

        public Builder jobType(JobType var1);

        public Builder resources(JobResource var1);

        default public Builder resources(Consumer<JobResource.Builder> resources) {
            return this.resources((JobResource)((JobResource.Builder)JobResource.builder().applyMutation(resources)).build());
        }

        public Builder onDeviceServiceConfiguration(OnDeviceServiceConfiguration var1);

        default public Builder onDeviceServiceConfiguration(Consumer<OnDeviceServiceConfiguration.Builder> onDeviceServiceConfiguration) {
            return this.onDeviceServiceConfiguration((OnDeviceServiceConfiguration)((OnDeviceServiceConfiguration.Builder)OnDeviceServiceConfiguration.builder().applyMutation(onDeviceServiceConfiguration)).build());
        }

        public Builder description(String var1);

        public Builder addressId(String var1);

        public Builder kmsKeyARN(String var1);

        public Builder roleARN(String var1);

        public Builder snowballCapacityPreference(String var1);

        public Builder snowballCapacityPreference(SnowballCapacity var1);

        public Builder shippingOption(String var1);

        public Builder shippingOption(ShippingOption var1);

        public Builder notification(Notification var1);

        default public Builder notification(Consumer<Notification.Builder> notification) {
            return this.notification((Notification)((Notification.Builder)Notification.builder().applyMutation(notification)).build());
        }

        public Builder clusterId(String var1);

        public Builder snowballType(String var1);

        public Builder snowballType(SnowballType var1);

        public Builder forwardingAddressId(String var1);

        public Builder taxDocuments(TaxDocuments var1);

        default public Builder taxDocuments(Consumer<TaxDocuments.Builder> taxDocuments) {
            return this.taxDocuments((TaxDocuments)((TaxDocuments.Builder)TaxDocuments.builder().applyMutation(taxDocuments)).build());
        }

        public Builder deviceConfiguration(DeviceConfiguration var1);

        default public Builder deviceConfiguration(Consumer<DeviceConfiguration.Builder> deviceConfiguration) {
            return this.deviceConfiguration((DeviceConfiguration)((DeviceConfiguration.Builder)DeviceConfiguration.builder().applyMutation(deviceConfiguration)).build());
        }

        public Builder remoteManagement(String var1);

        public Builder remoteManagement(RemoteManagement var1);

        public Builder longTermPricingId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

