/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.snowball.model.SnowballRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateLongTermPricingRequest
extends SnowballRequest
implements ToCopyableBuilder<Builder, UpdateLongTermPricingRequest> {
    private static final SdkField<String> LONG_TERM_PRICING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LongTermPricingId").getter(UpdateLongTermPricingRequest.getter(UpdateLongTermPricingRequest::longTermPricingId)).setter(UpdateLongTermPricingRequest.setter(Builder::longTermPricingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LongTermPricingId").build()}).build();
    private static final SdkField<String> REPLACEMENT_JOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplacementJob").getter(UpdateLongTermPricingRequest.getter(UpdateLongTermPricingRequest::replacementJob)).setter(UpdateLongTermPricingRequest.setter(Builder::replacementJob)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplacementJob").build()}).build();
    private static final SdkField<Boolean> IS_LONG_TERM_PRICING_AUTO_RENEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsLongTermPricingAutoRenew").getter(UpdateLongTermPricingRequest.getter(UpdateLongTermPricingRequest::isLongTermPricingAutoRenew)).setter(UpdateLongTermPricingRequest.setter(Builder::isLongTermPricingAutoRenew)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsLongTermPricingAutoRenew").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LONG_TERM_PRICING_ID_FIELD, REPLACEMENT_JOB_FIELD, IS_LONG_TERM_PRICING_AUTO_RENEW_FIELD));
    private final String longTermPricingId;
    private final String replacementJob;
    private final Boolean isLongTermPricingAutoRenew;

    private UpdateLongTermPricingRequest(BuilderImpl builder) {
        super(builder);
        this.longTermPricingId = builder.longTermPricingId;
        this.replacementJob = builder.replacementJob;
        this.isLongTermPricingAutoRenew = builder.isLongTermPricingAutoRenew;
    }

    public final String longTermPricingId() {
        return this.longTermPricingId;
    }

    public final String replacementJob() {
        return this.replacementJob;
    }

    public final Boolean isLongTermPricingAutoRenew() {
        return this.isLongTermPricingAutoRenew;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.longTermPricingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.replacementJob());
        hashCode = 31 * hashCode + Objects.hashCode(this.isLongTermPricingAutoRenew());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLongTermPricingRequest)) {
            return false;
        }
        UpdateLongTermPricingRequest other = (UpdateLongTermPricingRequest)((Object)obj);
        return Objects.equals(this.longTermPricingId(), other.longTermPricingId()) && Objects.equals(this.replacementJob(), other.replacementJob()) && Objects.equals(this.isLongTermPricingAutoRenew(), other.isLongTermPricingAutoRenew());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateLongTermPricingRequest").add("LongTermPricingId", (Object)this.longTermPricingId()).add("ReplacementJob", (Object)this.replacementJob()).add("IsLongTermPricingAutoRenew", (Object)this.isLongTermPricingAutoRenew()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LongTermPricingId": {
                return Optional.ofNullable(clazz.cast(this.longTermPricingId()));
            }
            case "ReplacementJob": {
                return Optional.ofNullable(clazz.cast(this.replacementJob()));
            }
            case "IsLongTermPricingAutoRenew": {
                return Optional.ofNullable(clazz.cast(this.isLongTermPricingAutoRenew()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLongTermPricingRequest, T> g) {
        return obj -> g.apply((UpdateLongTermPricingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SnowballRequest.BuilderImpl
    implements Builder {
        private String longTermPricingId;
        private String replacementJob;
        private Boolean isLongTermPricingAutoRenew;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLongTermPricingRequest model) {
            super(model);
            this.longTermPricingId(model.longTermPricingId);
            this.replacementJob(model.replacementJob);
            this.isLongTermPricingAutoRenew(model.isLongTermPricingAutoRenew);
        }

        public final String getLongTermPricingId() {
            return this.longTermPricingId;
        }

        @Override
        public final Builder longTermPricingId(String longTermPricingId) {
            this.longTermPricingId = longTermPricingId;
            return this;
        }

        public final void setLongTermPricingId(String longTermPricingId) {
            this.longTermPricingId = longTermPricingId;
        }

        public final String getReplacementJob() {
            return this.replacementJob;
        }

        @Override
        public final Builder replacementJob(String replacementJob) {
            this.replacementJob = replacementJob;
            return this;
        }

        public final void setReplacementJob(String replacementJob) {
            this.replacementJob = replacementJob;
        }

        public final Boolean getIsLongTermPricingAutoRenew() {
            return this.isLongTermPricingAutoRenew;
        }

        @Override
        public final Builder isLongTermPricingAutoRenew(Boolean isLongTermPricingAutoRenew) {
            this.isLongTermPricingAutoRenew = isLongTermPricingAutoRenew;
            return this;
        }

        public final void setIsLongTermPricingAutoRenew(Boolean isLongTermPricingAutoRenew) {
            this.isLongTermPricingAutoRenew = isLongTermPricingAutoRenew;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLongTermPricingRequest build() {
            return new UpdateLongTermPricingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SnowballRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateLongTermPricingRequest> {
        public Builder longTermPricingId(String var1);

        public Builder replacementJob(String var1);

        public Builder isLongTermPricingAutoRenew(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

