/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.snowball.model.JobMetadata;
import software.amazon.awssdk.services.snowball.model.JobMetadataListCopier;
import software.amazon.awssdk.services.snowball.model.SnowballResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeJobResponse
extends SnowballResponse
implements ToCopyableBuilder<Builder, DescribeJobResponse> {
    private static final SdkField<JobMetadata> JOB_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JobMetadata").getter(DescribeJobResponse.getter(DescribeJobResponse::jobMetadata)).setter(DescribeJobResponse.setter(Builder::jobMetadata)).constructor(JobMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobMetadata").build()}).build();
    private static final SdkField<List<JobMetadata>> SUB_JOB_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubJobMetadata").getter(DescribeJobResponse.getter(DescribeJobResponse::subJobMetadata)).setter(DescribeJobResponse.setter(Builder::subJobMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubJobMetadata").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(JobMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_METADATA_FIELD, SUB_JOB_METADATA_FIELD));
    private final JobMetadata jobMetadata;
    private final List<JobMetadata> subJobMetadata;

    private DescribeJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobMetadata = builder.jobMetadata;
        this.subJobMetadata = builder.subJobMetadata;
    }

    public JobMetadata jobMetadata() {
        return this.jobMetadata;
    }

    public boolean hasSubJobMetadata() {
        return this.subJobMetadata != null && !(this.subJobMetadata instanceof SdkAutoConstructList);
    }

    public List<JobMetadata> subJobMetadata() {
        return this.subJobMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubJobMetadata() ? this.subJobMetadata() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobResponse)) {
            return false;
        }
        DescribeJobResponse other = (DescribeJobResponse)((Object)obj);
        return Objects.equals(this.jobMetadata(), other.jobMetadata()) && this.hasSubJobMetadata() == other.hasSubJobMetadata() && Objects.equals(this.subJobMetadata(), other.subJobMetadata());
    }

    public String toString() {
        return ToString.builder((String)"DescribeJobResponse").add("JobMetadata", (Object)this.jobMetadata()).add("SubJobMetadata", this.hasSubJobMetadata() ? this.subJobMetadata() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobMetadata": {
                return Optional.ofNullable(clazz.cast(this.jobMetadata()));
            }
            case "SubJobMetadata": {
                return Optional.ofNullable(clazz.cast(this.subJobMetadata()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeJobResponse, T> g) {
        return obj -> g.apply((DescribeJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SnowballResponse.BuilderImpl
    implements Builder {
        private JobMetadata jobMetadata;
        private List<JobMetadata> subJobMetadata = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobResponse model) {
            super(model);
            this.jobMetadata(model.jobMetadata);
            this.subJobMetadata(model.subJobMetadata);
        }

        public final JobMetadata.Builder getJobMetadata() {
            return this.jobMetadata != null ? this.jobMetadata.toBuilder() : null;
        }

        @Override
        public final Builder jobMetadata(JobMetadata jobMetadata) {
            this.jobMetadata = jobMetadata;
            return this;
        }

        public final void setJobMetadata(JobMetadata.BuilderImpl jobMetadata) {
            this.jobMetadata = jobMetadata != null ? jobMetadata.build() : null;
        }

        public final Collection<JobMetadata.Builder> getSubJobMetadata() {
            if (this.subJobMetadata instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subJobMetadata != null ? (Collection)this.subJobMetadata.stream().map(JobMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder subJobMetadata(Collection<JobMetadata> subJobMetadata) {
            this.subJobMetadata = JobMetadataListCopier.copy(subJobMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subJobMetadata(JobMetadata ... subJobMetadata) {
            this.subJobMetadata(Arrays.asList(subJobMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subJobMetadata(Consumer<JobMetadata.Builder> ... subJobMetadata) {
            this.subJobMetadata(Stream.of(subJobMetadata).map(c -> (JobMetadata)((JobMetadata.Builder)JobMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSubJobMetadata(Collection<JobMetadata.BuilderImpl> subJobMetadata) {
            this.subJobMetadata = JobMetadataListCopier.copyFromBuilder(subJobMetadata);
        }

        @Override
        public DescribeJobResponse build() {
            return new DescribeJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SnowballResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeJobResponse> {
        public Builder jobMetadata(JobMetadata var1);

        default public Builder jobMetadata(Consumer<JobMetadata.Builder> jobMetadata) {
            return this.jobMetadata((JobMetadata)((JobMetadata.Builder)JobMetadata.builder().applyMutation(jobMetadata)).build());
        }

        public Builder subJobMetadata(Collection<JobMetadata> var1);

        public Builder subJobMetadata(JobMetadata ... var1);

        public Builder subJobMetadata(Consumer<JobMetadata.Builder> ... var1);
    }
}

