/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.snowball.model.ShipmentState;
import software.amazon.awssdk.services.snowball.model.SnowballRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateJobShipmentStateRequest
extends SnowballRequest
implements ToCopyableBuilder<Builder, UpdateJobShipmentStateRequest> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobId").getter(UpdateJobShipmentStateRequest.getter(UpdateJobShipmentStateRequest::jobId)).setter(UpdateJobShipmentStateRequest.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()}).build();
    private static final SdkField<String> SHIPMENT_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShipmentState").getter(UpdateJobShipmentStateRequest.getter(UpdateJobShipmentStateRequest::shipmentStateAsString)).setter(UpdateJobShipmentStateRequest.setter(Builder::shipmentState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShipmentState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, SHIPMENT_STATE_FIELD));
    private final String jobId;
    private final String shipmentState;

    private UpdateJobShipmentStateRequest(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.shipmentState = builder.shipmentState;
    }

    public String jobId() {
        return this.jobId;
    }

    public ShipmentState shipmentState() {
        return ShipmentState.fromValue(this.shipmentState);
    }

    public String shipmentStateAsString() {
        return this.shipmentState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.shipmentStateAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateJobShipmentStateRequest)) {
            return false;
        }
        UpdateJobShipmentStateRequest other = (UpdateJobShipmentStateRequest)((Object)obj);
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.shipmentStateAsString(), other.shipmentStateAsString());
    }

    public String toString() {
        return ToString.builder((String)"UpdateJobShipmentStateRequest").add("JobId", (Object)this.jobId()).add("ShipmentState", (Object)this.shipmentStateAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "ShipmentState": {
                return Optional.ofNullable(clazz.cast(this.shipmentStateAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateJobShipmentStateRequest, T> g) {
        return obj -> g.apply((UpdateJobShipmentStateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SnowballRequest.BuilderImpl
    implements Builder {
        private String jobId;
        private String shipmentState;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateJobShipmentStateRequest model) {
            super(model);
            this.jobId(model.jobId);
            this.shipmentState(model.shipmentState);
        }

        public final String getJobId() {
            return this.jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getShipmentState() {
            return this.shipmentState;
        }

        @Override
        public final Builder shipmentState(String shipmentState) {
            this.shipmentState = shipmentState;
            return this;
        }

        @Override
        public final Builder shipmentState(ShipmentState shipmentState) {
            this.shipmentState(shipmentState == null ? null : shipmentState.toString());
            return this;
        }

        public final void setShipmentState(String shipmentState) {
            this.shipmentState = shipmentState;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateJobShipmentStateRequest build() {
            return new UpdateJobShipmentStateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SnowballRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateJobShipmentStateRequest> {
        public Builder jobId(String var1);

        public Builder shipmentState(String var1);

        public Builder shipmentState(ShipmentState var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

