/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.snowball.model.ClusterListEntry;
import software.amazon.awssdk.services.snowball.model.ClusterListEntryListCopier;
import software.amazon.awssdk.services.snowball.model.SnowballResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListClustersResponse
extends SnowballResponse
implements ToCopyableBuilder<Builder, ListClustersResponse> {
    private static final SdkField<List<ClusterListEntry>> CLUSTER_LIST_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListClustersResponse.getter(ListClustersResponse::clusterListEntries)).setter(ListClustersResponse.setter(Builder::clusterListEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterListEntries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterListEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListClustersResponse.getter(ListClustersResponse::nextToken)).setter(ListClustersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_LIST_ENTRIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<ClusterListEntry> clusterListEntries;
    private final String nextToken;

    private ListClustersResponse(BuilderImpl builder) {
        super(builder);
        this.clusterListEntries = builder.clusterListEntries;
        this.nextToken = builder.nextToken;
    }

    public List<ClusterListEntry> clusterListEntries() {
        return this.clusterListEntries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterListEntries());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClustersResponse)) {
            return false;
        }
        ListClustersResponse other = (ListClustersResponse)((Object)obj);
        return Objects.equals(this.clusterListEntries(), other.clusterListEntries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListClustersResponse").add("ClusterListEntries", this.clusterListEntries()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterListEntries": {
                return Optional.ofNullable(clazz.cast(this.clusterListEntries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListClustersResponse, T> g) {
        return obj -> g.apply((ListClustersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SnowballResponse.BuilderImpl
    implements Builder {
        private List<ClusterListEntry> clusterListEntries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClustersResponse model) {
            super(model);
            this.clusterListEntries(model.clusterListEntries);
            this.nextToken(model.nextToken);
        }

        public final Collection<ClusterListEntry.Builder> getClusterListEntries() {
            return this.clusterListEntries != null ? (Collection)this.clusterListEntries.stream().map(ClusterListEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder clusterListEntries(Collection<ClusterListEntry> clusterListEntries) {
            this.clusterListEntries = ClusterListEntryListCopier.copy(clusterListEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterListEntries(ClusterListEntry ... clusterListEntries) {
            this.clusterListEntries(Arrays.asList(clusterListEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterListEntries(Consumer<ClusterListEntry.Builder> ... clusterListEntries) {
            this.clusterListEntries(Stream.of(clusterListEntries).map(c -> (ClusterListEntry)((ClusterListEntry.Builder)ClusterListEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setClusterListEntries(Collection<ClusterListEntry.BuilderImpl> clusterListEntries) {
            this.clusterListEntries = ClusterListEntryListCopier.copyFromBuilder(clusterListEntries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListClustersResponse build() {
            return new ListClustersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SnowballResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListClustersResponse> {
        public Builder clusterListEntries(Collection<ClusterListEntry> var1);

        public Builder clusterListEntries(ClusterListEntry ... var1);

        public Builder clusterListEntries(Consumer<ClusterListEntry.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

