/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SnowballType {
    STANDARD("STANDARD"),
    EDGE("EDGE"),
    EDGE_C("EDGE_C"),
    EDGE_CG("EDGE_CG"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private SnowballType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SnowballType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(SnowballType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SnowballType> knownValues() {
        return Stream.of(SnowballType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

