/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.snowball.model.JobResource;

@SdkInternalApi
public class JobResourceMarshaller {
    private static final MarshallingInfo<List> S3RESOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Resources").build();
    private static final MarshallingInfo<List> LAMBDARESOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LambdaResources").build();
    private static final JobResourceMarshaller INSTANCE = new JobResourceMarshaller();

    public static JobResourceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(JobResource jobResource, ProtocolMarshaller protocolMarshaller) {
        if (jobResource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(jobResource.s3Resources(), S3RESOURCES_BINDING);
            protocolMarshaller.marshall(jobResource.lambdaResources(), LAMBDARESOURCES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

