/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.model.Shipment;
import software.amazon.awssdk.services.snowball.model.ShippingOption;
import software.amazon.awssdk.services.snowball.transform.ShippingDetailsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ShippingDetails
implements StructuredPojo,
ToCopyableBuilder<Builder, ShippingDetails> {
    private final String shippingOption;
    private final Shipment inboundShipment;
    private final Shipment outboundShipment;

    private ShippingDetails(BuilderImpl builder) {
        this.shippingOption = builder.shippingOption;
        this.inboundShipment = builder.inboundShipment;
        this.outboundShipment = builder.outboundShipment;
    }

    public ShippingOption shippingOption() {
        return ShippingOption.fromValue(this.shippingOption);
    }

    public String shippingOptionString() {
        return this.shippingOption;
    }

    public Shipment inboundShipment() {
        return this.inboundShipment;
    }

    public Shipment outboundShipment() {
        return this.outboundShipment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.shippingOptionString());
        hashCode = 31 * hashCode + Objects.hashCode(this.inboundShipment());
        hashCode = 31 * hashCode + Objects.hashCode(this.outboundShipment());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShippingDetails)) {
            return false;
        }
        ShippingDetails other = (ShippingDetails)obj;
        return Objects.equals(this.shippingOptionString(), other.shippingOptionString()) && Objects.equals(this.inboundShipment(), other.inboundShipment()) && Objects.equals(this.outboundShipment(), other.outboundShipment());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.shippingOptionString() != null) {
            sb.append("ShippingOption: ").append(this.shippingOptionString()).append(",");
        }
        if (this.inboundShipment() != null) {
            sb.append("InboundShipment: ").append(this.inboundShipment()).append(",");
        }
        if (this.outboundShipment() != null) {
            sb.append("OutboundShipment: ").append(this.outboundShipment()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ShippingOption": {
                return Optional.of(clazz.cast(this.shippingOptionString()));
            }
            case "InboundShipment": {
                return Optional.of(clazz.cast(this.inboundShipment()));
            }
            case "OutboundShipment": {
                return Optional.of(clazz.cast(this.outboundShipment()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ShippingDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String shippingOption;
        private Shipment inboundShipment;
        private Shipment outboundShipment;

        private BuilderImpl() {
        }

        private BuilderImpl(ShippingDetails model) {
            this.shippingOption(model.shippingOption);
            this.inboundShipment(model.inboundShipment);
            this.outboundShipment(model.outboundShipment);
        }

        public final String getShippingOption() {
            return this.shippingOption;
        }

        @Override
        public final Builder shippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
            return this;
        }

        @Override
        public final Builder shippingOption(ShippingOption shippingOption) {
            this.shippingOption(shippingOption.toString());
            return this;
        }

        public final void setShippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
        }

        public final Shipment.Builder getInboundShipment() {
            return this.inboundShipment != null ? this.inboundShipment.toBuilder() : null;
        }

        @Override
        public final Builder inboundShipment(Shipment inboundShipment) {
            this.inboundShipment = inboundShipment;
            return this;
        }

        public final void setInboundShipment(Shipment.BuilderImpl inboundShipment) {
            this.inboundShipment = inboundShipment != null ? inboundShipment.build() : null;
        }

        public final Shipment.Builder getOutboundShipment() {
            return this.outboundShipment != null ? this.outboundShipment.toBuilder() : null;
        }

        @Override
        public final Builder outboundShipment(Shipment outboundShipment) {
            this.outboundShipment = outboundShipment;
            return this;
        }

        public final void setOutboundShipment(Shipment.BuilderImpl outboundShipment) {
            this.outboundShipment = outboundShipment != null ? outboundShipment.build() : null;
        }

        public ShippingDetails build() {
            return new ShippingDetails(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ShippingDetails> {
        public Builder shippingOption(String var1);

        public Builder shippingOption(ShippingOption var1);

        public Builder inboundShipment(Shipment var1);

        default public Builder inboundShipment(Consumer<Shipment.Builder> inboundShipment) {
            return this.inboundShipment((Shipment)((Shipment.Builder)Shipment.builder().apply(inboundShipment)).build());
        }

        public Builder outboundShipment(Shipment var1);

        default public Builder outboundShipment(Consumer<Shipment.Builder> outboundShipment) {
            return this.outboundShipment((Shipment)((Shipment.Builder)Shipment.builder().apply(outboundShipment)).build());
        }
    }
}

