/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.snowball.model.KeyRange;

@SdkInternalApi
public class KeyRangeMarshaller {
    private static final MarshallingInfo<String> BEGINMARKER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BeginMarker").build();
    private static final MarshallingInfo<String> ENDMARKER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndMarker").build();
    private static final KeyRangeMarshaller INSTANCE = new KeyRangeMarshaller();

    public static KeyRangeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(KeyRange keyRange, ProtocolMarshaller protocolMarshaller) {
        if (keyRange == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)keyRange.beginMarker(), BEGINMARKER_BINDING);
            protocolMarshaller.marshall((Object)keyRange.endMarker(), ENDMARKER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

