/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.model.CreateJobRequest;

@SdkInternalApi
public class CreateJobRequestModelMarshaller {
    private static final MarshallingInfo<String> JOBTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobType").build();
    private static final MarshallingInfo<StructuredPojo> RESOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Resources").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<String> ADDRESSID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AddressId").build();
    private static final MarshallingInfo<String> KMSKEYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KmsKeyARN").build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleARN").build();
    private static final MarshallingInfo<String> SNOWBALLCAPACITYPREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SnowballCapacityPreference").build();
    private static final MarshallingInfo<String> SHIPPINGOPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ShippingOption").build();
    private static final MarshallingInfo<StructuredPojo> NOTIFICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Notification").build();
    private static final MarshallingInfo<String> CLUSTERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterId").build();
    private static final MarshallingInfo<String> SNOWBALLTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SnowballType").build();
    private static final MarshallingInfo<String> FORWARDINGADDRESSID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ForwardingAddressId").build();
    private static final CreateJobRequestModelMarshaller INSTANCE = new CreateJobRequestModelMarshaller();

    public static CreateJobRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateJobRequest createJobRequest, ProtocolMarshaller protocolMarshaller) {
        if (createJobRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)createJobRequest.jobTypeString(), JOBTYPE_BINDING);
            protocolMarshaller.marshall((Object)createJobRequest.resources(), RESOURCES_BINDING);
            protocolMarshaller.marshall((Object)createJobRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)createJobRequest.addressId(), ADDRESSID_BINDING);
            protocolMarshaller.marshall((Object)createJobRequest.kmsKeyARN(), KMSKEYARN_BINDING);
            protocolMarshaller.marshall((Object)createJobRequest.roleARN(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)createJobRequest.snowballCapacityPreferenceString(), SNOWBALLCAPACITYPREFERENCE_BINDING);
            protocolMarshaller.marshall((Object)createJobRequest.shippingOptionString(), SHIPPINGOPTION_BINDING);
            protocolMarshaller.marshall((Object)createJobRequest.notification(), NOTIFICATION_BINDING);
            protocolMarshaller.marshall((Object)createJobRequest.clusterId(), CLUSTERID_BINDING);
            protocolMarshaller.marshall((Object)createJobRequest.snowballTypeString(), SNOWBALLTYPE_BINDING);
            protocolMarshaller.marshall((Object)createJobRequest.forwardingAddressId(), FORWARDINGADDRESSID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

