/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.transform.ShipmentMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Shipment
implements StructuredPojo,
ToCopyableBuilder<Builder, Shipment> {
    private final String status;
    private final String trackingNumber;

    private Shipment(BuilderImpl builder) {
        this.status = builder.status;
        this.trackingNumber = builder.trackingNumber;
    }

    public String status() {
        return this.status;
    }

    public String trackingNumber() {
        return this.trackingNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.trackingNumber() == null ? 0 : this.trackingNumber().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Shipment)) {
            return false;
        }
        Shipment other = (Shipment)obj;
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.trackingNumber() == null ^ this.trackingNumber() == null) {
            return false;
        }
        return other.trackingNumber() == null || other.trackingNumber().equals(this.trackingNumber());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.trackingNumber() != null) {
            sb.append("TrackingNumber: ").append(this.trackingNumber()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "TrackingNumber": {
                return Optional.of(clazz.cast(this.trackingNumber()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ShipmentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String trackingNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(Shipment model) {
            this.status(model.status);
            this.trackingNumber(model.trackingNumber);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getTrackingNumber() {
            return this.trackingNumber;
        }

        @Override
        public final Builder trackingNumber(String trackingNumber) {
            this.trackingNumber = trackingNumber;
            return this;
        }

        public final void setTrackingNumber(String trackingNumber) {
            this.trackingNumber = trackingNumber;
        }

        public Shipment build() {
            return new Shipment(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Shipment> {
        public Builder status(String var1);

        public Builder trackingNumber(String var1);
    }
}

