/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.snowball.model.ClusterListEntry;
import software.amazon.awssdk.services.snowball.model.ClusterListEntryListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListClustersResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListClustersResponse> {
    private final List<ClusterListEntry> clusterListEntries;
    private final String nextToken;

    private ListClustersResponse(BuilderImpl builder) {
        this.clusterListEntries = builder.clusterListEntries;
        this.nextToken = builder.nextToken;
    }

    public List<ClusterListEntry> clusterListEntries() {
        return this.clusterListEntries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clusterListEntries() == null ? 0 : this.clusterListEntries().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClustersResponse)) {
            return false;
        }
        ListClustersResponse other = (ListClustersResponse)((Object)obj);
        if (other.clusterListEntries() == null ^ this.clusterListEntries() == null) {
            return false;
        }
        if (other.clusterListEntries() != null && !other.clusterListEntries().equals(this.clusterListEntries())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.clusterListEntries() != null) {
            sb.append("ClusterListEntries: ").append(this.clusterListEntries()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterListEntries": {
                return Optional.of(clazz.cast(this.clusterListEntries()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<ClusterListEntry> clusterListEntries;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClustersResponse model) {
            this.clusterListEntries(model.clusterListEntries);
            this.nextToken(model.nextToken);
        }

        public final Collection<ClusterListEntry.Builder> getClusterListEntries() {
            return this.clusterListEntries != null ? (Collection)this.clusterListEntries.stream().map(ClusterListEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder clusterListEntries(Collection<ClusterListEntry> clusterListEntries) {
            this.clusterListEntries = ClusterListEntryListCopier.copy(clusterListEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterListEntries(ClusterListEntry ... clusterListEntries) {
            this.clusterListEntries(Arrays.asList(clusterListEntries));
            return this;
        }

        public final void setClusterListEntries(Collection<ClusterListEntry.BuilderImpl> clusterListEntries) {
            this.clusterListEntries = ClusterListEntryListCopier.copyFromBuilder(clusterListEntries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListClustersResponse build() {
            return new ListClustersResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListClustersResponse> {
        public Builder clusterListEntries(Collection<ClusterListEntry> var1);

        public Builder clusterListEntries(ClusterListEntry ... var1);

        public Builder nextToken(String var1);
    }
}

