/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.transform.DataTransferMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DataTransfer
implements StructuredPojo,
ToCopyableBuilder<Builder, DataTransfer> {
    private final Long bytesTransferred;
    private final Long objectsTransferred;
    private final Long totalBytes;
    private final Long totalObjects;

    private DataTransfer(BuilderImpl builder) {
        this.bytesTransferred = builder.bytesTransferred;
        this.objectsTransferred = builder.objectsTransferred;
        this.totalBytes = builder.totalBytes;
        this.totalObjects = builder.totalObjects;
    }

    public Long bytesTransferred() {
        return this.bytesTransferred;
    }

    public Long objectsTransferred() {
        return this.objectsTransferred;
    }

    public Long totalBytes() {
        return this.totalBytes;
    }

    public Long totalObjects() {
        return this.totalObjects;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.bytesTransferred() == null ? 0 : this.bytesTransferred().hashCode());
        hashCode = 31 * hashCode + (this.objectsTransferred() == null ? 0 : this.objectsTransferred().hashCode());
        hashCode = 31 * hashCode + (this.totalBytes() == null ? 0 : this.totalBytes().hashCode());
        hashCode = 31 * hashCode + (this.totalObjects() == null ? 0 : this.totalObjects().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataTransfer)) {
            return false;
        }
        DataTransfer other = (DataTransfer)obj;
        if (other.bytesTransferred() == null ^ this.bytesTransferred() == null) {
            return false;
        }
        if (other.bytesTransferred() != null && !other.bytesTransferred().equals(this.bytesTransferred())) {
            return false;
        }
        if (other.objectsTransferred() == null ^ this.objectsTransferred() == null) {
            return false;
        }
        if (other.objectsTransferred() != null && !other.objectsTransferred().equals(this.objectsTransferred())) {
            return false;
        }
        if (other.totalBytes() == null ^ this.totalBytes() == null) {
            return false;
        }
        if (other.totalBytes() != null && !other.totalBytes().equals(this.totalBytes())) {
            return false;
        }
        if (other.totalObjects() == null ^ this.totalObjects() == null) {
            return false;
        }
        return other.totalObjects() == null || other.totalObjects().equals(this.totalObjects());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.bytesTransferred() != null) {
            sb.append("BytesTransferred: ").append(this.bytesTransferred()).append(",");
        }
        if (this.objectsTransferred() != null) {
            sb.append("ObjectsTransferred: ").append(this.objectsTransferred()).append(",");
        }
        if (this.totalBytes() != null) {
            sb.append("TotalBytes: ").append(this.totalBytes()).append(",");
        }
        if (this.totalObjects() != null) {
            sb.append("TotalObjects: ").append(this.totalObjects()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BytesTransferred": {
                return Optional.of(clazz.cast(this.bytesTransferred()));
            }
            case "ObjectsTransferred": {
                return Optional.of(clazz.cast(this.objectsTransferred()));
            }
            case "TotalBytes": {
                return Optional.of(clazz.cast(this.totalBytes()));
            }
            case "TotalObjects": {
                return Optional.of(clazz.cast(this.totalObjects()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DataTransferMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Long bytesTransferred;
        private Long objectsTransferred;
        private Long totalBytes;
        private Long totalObjects;

        private BuilderImpl() {
        }

        private BuilderImpl(DataTransfer model) {
            this.bytesTransferred(model.bytesTransferred);
            this.objectsTransferred(model.objectsTransferred);
            this.totalBytes(model.totalBytes);
            this.totalObjects(model.totalObjects);
        }

        public final Long getBytesTransferred() {
            return this.bytesTransferred;
        }

        @Override
        public final Builder bytesTransferred(Long bytesTransferred) {
            this.bytesTransferred = bytesTransferred;
            return this;
        }

        public final void setBytesTransferred(Long bytesTransferred) {
            this.bytesTransferred = bytesTransferred;
        }

        public final Long getObjectsTransferred() {
            return this.objectsTransferred;
        }

        @Override
        public final Builder objectsTransferred(Long objectsTransferred) {
            this.objectsTransferred = objectsTransferred;
            return this;
        }

        public final void setObjectsTransferred(Long objectsTransferred) {
            this.objectsTransferred = objectsTransferred;
        }

        public final Long getTotalBytes() {
            return this.totalBytes;
        }

        @Override
        public final Builder totalBytes(Long totalBytes) {
            this.totalBytes = totalBytes;
            return this;
        }

        public final void setTotalBytes(Long totalBytes) {
            this.totalBytes = totalBytes;
        }

        public final Long getTotalObjects() {
            return this.totalObjects;
        }

        @Override
        public final Builder totalObjects(Long totalObjects) {
            this.totalObjects = totalObjects;
            return this;
        }

        public final void setTotalObjects(Long totalObjects) {
            this.totalObjects = totalObjects;
        }

        public DataTransfer build() {
            return new DataTransfer(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DataTransfer> {
        public Builder bytesTransferred(Long var1);

        public Builder objectsTransferred(Long var1);

        public Builder totalBytes(Long var1);

        public Builder totalObjects(Long var1);
    }
}

