/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.transform;

import java.time.Instant;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.snowball.model.JobListEntry;

@SdkInternalApi
public class JobListEntryMarshaller {
    private static final MarshallingInfo<String> JOBID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobId").build();
    private static final MarshallingInfo<String> JOBSTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobState").build();
    private static final MarshallingInfo<Boolean> ISMASTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IsMaster").build();
    private static final MarshallingInfo<String> JOBTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobType").build();
    private static final MarshallingInfo<String> SNOWBALLTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SnowballType").build();
    private static final MarshallingInfo<Instant> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDate").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final JobListEntryMarshaller INSTANCE = new JobListEntryMarshaller();

    public static JobListEntryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(JobListEntry jobListEntry, ProtocolMarshaller protocolMarshaller) {
        if (jobListEntry == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)jobListEntry.jobId(), JOBID_BINDING);
            protocolMarshaller.marshall((Object)jobListEntry.jobState(), JOBSTATE_BINDING);
            protocolMarshaller.marshall((Object)jobListEntry.isMaster(), ISMASTER_BINDING);
            protocolMarshaller.marshall((Object)jobListEntry.jobType(), JOBTYPE_BINDING);
            protocolMarshaller.marshall((Object)jobListEntry.snowballType(), SNOWBALLTYPE_BINDING);
            protocolMarshaller.marshall((Object)jobListEntry.creationDate(), CREATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)jobListEntry.description(), DESCRIPTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

