/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.transform;

import java.time.Instant;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.snowball.model.ClusterListEntry;

@SdkInternalApi
public class ClusterListEntryMarshaller {
    private static final MarshallingInfo<String> CLUSTERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterId").build();
    private static final MarshallingInfo<String> CLUSTERSTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterState").build();
    private static final MarshallingInfo<Instant> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDate").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final ClusterListEntryMarshaller INSTANCE = new ClusterListEntryMarshaller();

    public static ClusterListEntryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ClusterListEntry clusterListEntry, ProtocolMarshaller protocolMarshaller) {
        if (clusterListEntry == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)clusterListEntry.clusterId(), CLUSTERID_BINDING);
            protocolMarshaller.marshall((Object)clusterListEntry.clusterState(), CLUSTERSTATE_BINDING);
            protocolMarshaller.marshall((Object)clusterListEntry.creationDate(), CREATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)clusterListEntry.description(), DESCRIPTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

